/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.util;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.pinot.common.exception.InvalidConfigException;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerGauge;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.common.restlet.resources.SegmentSizeInfo;
import org.apache.pinot.controller.api.resources.ServerTableSizeReader;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableSizeReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableSizeReader.class);
    private final Executor _executor;
    private final HttpConnectionManager _connectionManager;
    private final PinotHelixResourceManager _helixResourceManager;
    private final ControllerMetrics _controllerMetrics;

    public TableSizeReader(Executor executor, HttpConnectionManager connectionManager, ControllerMetrics controllerMetrics, PinotHelixResourceManager helixResourceManager) {
        this._executor = executor;
        this._connectionManager = connectionManager;
        this._controllerMetrics = controllerMetrics;
        this._helixResourceManager = helixResourceManager;
    }

    @Nullable
    public TableSizeDetails getTableSizeDetails(@Nonnull String tableName, @Nonnegative int timeoutMsec) throws InvalidConfigException {
        Preconditions.checkNotNull((Object)tableName, (Object)"Table name should not be null");
        Preconditions.checkArgument((timeoutMsec > 0 ? 1 : 0) != 0, (Object)"Timeout value must be greater than 0");
        boolean hasRealtimeTable = false;
        boolean hasOfflineTable = false;
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableName);
        if (tableType != null) {
            hasRealtimeTable = tableType == TableType.REALTIME;
            hasOfflineTable = tableType == TableType.OFFLINE;
        } else {
            hasRealtimeTable = this._helixResourceManager.hasRealtimeTable(tableName);
            hasOfflineTable = this._helixResourceManager.hasOfflineTable(tableName);
        }
        if (!hasOfflineTable && !hasRealtimeTable) {
            return null;
        }
        TableSizeDetails tableSizeDetails = new TableSizeDetails(tableName);
        if (hasRealtimeTable) {
            String realtimeTableName = TableNameBuilder.REALTIME.tableNameWithType(tableName);
            tableSizeDetails._realtimeSegments = this.getTableSubtypeSize(realtimeTableName, timeoutMsec);
            tableSizeDetails._reportedSizeInBytes += tableSizeDetails._realtimeSegments._reportedSizeInBytes;
            tableSizeDetails._estimatedSizeInBytes += tableSizeDetails._realtimeSegments._estimatedSizeInBytes;
        }
        if (hasOfflineTable) {
            String offlineTableName = TableNameBuilder.OFFLINE.tableNameWithType(tableName);
            tableSizeDetails._offlineSegments = this.getTableSubtypeSize(offlineTableName, timeoutMsec);
            tableSizeDetails._reportedSizeInBytes += tableSizeDetails._offlineSegments._reportedSizeInBytes;
            tableSizeDetails._estimatedSizeInBytes += tableSizeDetails._offlineSegments._estimatedSizeInBytes;
        }
        return tableSizeDetails;
    }

    public TableSubTypeSizeDetails getTableSubtypeSize(String tableNameWithType, int timeoutMs) throws InvalidConfigException {
        Map<String, List<String>> serverToSegmentsMap = this._helixResourceManager.getServerToSegmentsMap(tableNameWithType);
        ServerTableSizeReader serverTableSizeReader = new ServerTableSizeReader(this._executor, this._connectionManager);
        BiMap<String, String> endpoints = this._helixResourceManager.getDataInstanceAdminEndpoints(serverToSegmentsMap.keySet());
        Map<String, List<SegmentSizeInfo>> serverToSegmentSizeInfoListMap = serverTableSizeReader.getSegmentSizeInfoFromServers(endpoints, tableNameWithType, timeoutMs);
        TableSubTypeSizeDetails subTypeSizeDetails = new TableSubTypeSizeDetails();
        Map<String, SegmentSizeDetails> segmentToSizeDetailsMap = subTypeSizeDetails._segments;
        for (Map.Entry<String, List<String>> entry : serverToSegmentsMap.entrySet()) {
            SegmentSizeInfo segmentSizeInfo22;
            String string = entry.getKey();
            List<SegmentSizeInfo> segmentSizeInfoList = serverToSegmentSizeInfoListMap.get(string);
            if (segmentSizeInfoList != null) {
                for (SegmentSizeInfo segmentSizeInfo22 : segmentSizeInfoList) {
                    SegmentSizeDetails segmentSizeDetails = segmentToSizeDetailsMap.computeIfAbsent(segmentSizeInfo22.getSegmentName(), k -> new SegmentSizeDetails());
                    segmentSizeDetails._serverInfo.put(string, segmentSizeInfo22);
                }
                continue;
            }
            List segments = (List)entry.getValue();
            segmentSizeInfo22 = segments.iterator();
            while (segmentSizeInfo22.hasNext()) {
                String segment = (String)segmentSizeInfo22.next();
                SegmentSizeDetails segmentSizeDetails = segmentToSizeDetailsMap.computeIfAbsent(segment, k -> new SegmentSizeDetails());
                segmentSizeDetails._serverInfo.put(string, new SegmentSizeInfo(segment, -1L));
            }
        }
        ArrayList<String> missingSegments = new ArrayList<String>();
        for (Map.Entry entry : segmentToSizeDetailsMap.entrySet()) {
            String segment = (String)entry.getKey();
            SegmentSizeDetails sizeDetails = (SegmentSizeDetails)entry.getValue();
            long segmentLevelMax = -1L;
            int errors = 0;
            for (SegmentSizeInfo sizeInfo : sizeDetails._serverInfo.values()) {
                if (sizeInfo.getDiskSizeInBytes() != -1L) {
                    sizeDetails._reportedSizeInBytes += sizeInfo.getDiskSizeInBytes();
                    segmentLevelMax = Math.max(segmentLevelMax, sizeInfo.getDiskSizeInBytes());
                    continue;
                }
                ++errors;
            }
            if (errors != sizeDetails._serverInfo.size()) {
                sizeDetails._estimatedSizeInBytes = sizeDetails._reportedSizeInBytes + (long)errors * segmentLevelMax;
                subTypeSizeDetails._reportedSizeInBytes += sizeDetails._reportedSizeInBytes;
                subTypeSizeDetails._estimatedSizeInBytes += sizeDetails._estimatedSizeInBytes;
                continue;
            }
            missingSegments.add(segment);
            sizeDetails._reportedSizeInBytes = -1L;
            sizeDetails._estimatedSizeInBytes = -1L;
            ++subTypeSizeDetails._missingSegments;
        }
        if (subTypeSizeDetails._missingSegments > 0) {
            int numSegments = segmentToSizeDetailsMap.size();
            int n = subTypeSizeDetails._missingSegments * 100 / numSegments;
            this._controllerMetrics.setValueOfTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.TABLE_STORAGE_EST_MISSING_SEGMENT_PERCENT, (long)n);
            if (subTypeSizeDetails._missingSegments == numSegments) {
                LOGGER.warn("Failed to get size report for all {} segments of table: {}", (Object)numSegments, (Object)tableNameWithType);
                subTypeSizeDetails._reportedSizeInBytes = -1L;
                subTypeSizeDetails._estimatedSizeInBytes = -1L;
            } else {
                LOGGER.warn("Missing size report for {} out of {} segments for table {}", new Object[]{subTypeSizeDetails._missingSegments, numSegments, tableNameWithType});
            }
        } else {
            this._controllerMetrics.setValueOfTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.TABLE_STORAGE_EST_MISSING_SEGMENT_PERCENT, 0L);
        }
        return subTypeSizeDetails;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SegmentSizeDetails {
        @JsonProperty(value="reportedSizeInBytes")
        public long _reportedSizeInBytes = 0L;
        @JsonProperty(value="estimatedSizeInBytes")
        public long _estimatedSizeInBytes = 0L;
        @JsonProperty(value="serverInfo")
        public Map<String, SegmentSizeInfo> _serverInfo = new HashMap<String, SegmentSizeInfo>();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TableSubTypeSizeDetails {
        @JsonProperty(value="reportedSizeInBytes")
        public long _reportedSizeInBytes = 0L;
        @JsonProperty(value="estimatedSizeInBytes")
        public long _estimatedSizeInBytes = 0L;
        @JsonProperty(value="missingSegments")
        public int _missingSegments = 0;
        @JsonProperty(value="segments")
        public Map<String, SegmentSizeDetails> _segments = new HashMap<String, SegmentSizeDetails>();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TableSizeDetails {
        @JsonProperty(value="tableName")
        public String _tableName;
        @JsonProperty(value="reportedSizeInBytes")
        public long _reportedSizeInBytes = 0L;
        @JsonProperty(value="estimatedSizeInBytes")
        public long _estimatedSizeInBytes = 0L;
        @JsonProperty(value="offlineSegments")
        public TableSubTypeSizeDetails _offlineSegments;
        @JsonProperty(value="realtimeSegments")
        public TableSubTypeSizeDetails _realtimeSegments;

        public TableSizeDetails(String tableName) {
            this._tableName = tableName;
        }
    }
}

