/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.rules.utils;

import org.apache.pinot.controller.recommender.rules.utils.FixedLenBitset;
import org.apache.pinot.controller.recommender.rules.utils.QueryInvertedSortedIndexRecommender;

public class PredicateParseResult {
    public static final double PERCENT_SELECT_ALL = 1.0;
    public static final double PERCENT_SELECT_ZERO = 0.0;
    public static final double NESI_ZERO = 0.0;
    public static final double NESI_ONE = 1.0;
    FixedLenBitset _candidateDims;
    QueryInvertedSortedIndexRecommender.IteratorEvalPriorityEnum _iteratorEvalPriorityEnum;
    QueryInvertedSortedIndexRecommender.RecommendationPriorityEnum _recommendationPriorityEnum;
    double _nESI;
    double _nESIWithIdx;
    double _percentSelected;

    public String toString() {
        return "PredicateParseResult{dims" + this._candidateDims + ", " + this._iteratorEvalPriorityEnum + ", " + this._recommendationPriorityEnum + ", nESI=" + String.format("%.3f", this._nESI) + ", selected=" + String.format("%.3f", this._percentSelected) + ", nESIWithIdx=" + String.format("%.3f", this._nESIWithIdx) + "}";
    }

    public boolean hasCandidateDim() {
        return this._candidateDims.hasCandidateDim();
    }

    public boolean isBitmapConvertable() {
        return this._recommendationPriorityEnum == QueryInvertedSortedIndexRecommender.RecommendationPriorityEnum.BITMAP || this._recommendationPriorityEnum == QueryInvertedSortedIndexRecommender.RecommendationPriorityEnum.CANDIDATE_SCAN;
    }

    public FixedLenBitset getCandidateDims() {
        return this._candidateDims;
    }

    public QueryInvertedSortedIndexRecommender.IteratorEvalPriorityEnum getIteratorEvalPriority() {
        return this._iteratorEvalPriorityEnum;
    }

    public QueryInvertedSortedIndexRecommender.RecommendationPriorityEnum getRecommendationPriorityEnum() {
        return this._recommendationPriorityEnum;
    }

    public double getnESI() {
        return this._nESI;
    }

    public double getPercentSelected() {
        return this._percentSelected;
    }

    public double getnESIWithIdx() {
        return this._nESIWithIdx;
    }

    public PredicateParseResult multiplyWeight(double queryWeight) {
        this._nESI *= queryWeight;
        this._nESIWithIdx *= queryWeight;
        return this;
    }

    public static PredicateParseResult emptyPredicateParseResult() {
        return PredicateParseResultBuilder.aPredicateParseResult().setCandidateDims(FixedLenBitset.IMMUTABLE_EMPTY_SET).setIteratorEvalPriorityEnum(QueryInvertedSortedIndexRecommender.IteratorEvalPriorityEnum.INDEXED).setRecommendationPriorityEnum(QueryInvertedSortedIndexRecommender.RecommendationPriorityEnum.NON_CANDIDATE_SCAN).setnESI(0.0).setPercentSelected(0.0).setnESIWithIdx(0.0).build();
    }

    public static final class PredicateParseResultBuilder {
        FixedLenBitset _candidateDims;
        QueryInvertedSortedIndexRecommender.IteratorEvalPriorityEnum _iteratorEvalPriorityEnum;
        QueryInvertedSortedIndexRecommender.RecommendationPriorityEnum _recommendationPriorityEnum;
        double _nESI;
        double _nESIWithIdx;
        double _percentSelected;

        public static PredicateParseResultBuilder aPredicateParseResult() {
            return new PredicateParseResultBuilder();
        }

        public PredicateParseResultBuilder setCandidateDims(FixedLenBitset candidateDims) {
            this._candidateDims = candidateDims;
            return this;
        }

        public PredicateParseResultBuilder setIteratorEvalPriorityEnum(QueryInvertedSortedIndexRecommender.IteratorEvalPriorityEnum iteratorEvalPriorityEnum) {
            this._iteratorEvalPriorityEnum = iteratorEvalPriorityEnum;
            return this;
        }

        public PredicateParseResultBuilder setRecommendationPriorityEnum(QueryInvertedSortedIndexRecommender.RecommendationPriorityEnum recommendationPriorityEnum) {
            this._recommendationPriorityEnum = recommendationPriorityEnum;
            return this;
        }

        public PredicateParseResultBuilder setnESI(double nESI) {
            this._nESI = nESI;
            return this;
        }

        public PredicateParseResultBuilder setPercentSelected(double percentSelected) {
            this._percentSelected = percentSelected;
            return this;
        }

        public PredicateParseResultBuilder setnESIWithIdx(double nESIWithIdx) {
            this._nESIWithIdx = nESIWithIdx;
            return this;
        }

        public PredicateParseResultBuilder setQueryWeight(double queryWeight) {
            this._nESI *= queryWeight;
            this._nESIWithIdx *= queryWeight;
            return this;
        }

        public PredicateParseResult build() {
            PredicateParseResult predicateParseResult = new PredicateParseResult();
            predicateParseResult._candidateDims = this._candidateDims;
            predicateParseResult._percentSelected = this._percentSelected;
            predicateParseResult._nESI = this._nESI;
            predicateParseResult._iteratorEvalPriorityEnum = this._iteratorEvalPriorityEnum;
            predicateParseResult._recommendationPriorityEnum = this._recommendationPriorityEnum;
            predicateParseResult._nESIWithIdx = this._nESIWithIdx;
            return predicateParseResult;
        }
    }
}

