/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data.generator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.pinot.controller.recommender.data.generator.Generator;
import org.apache.pinot.plugin.inputformat.avro.AvroSchemaUtil;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.JsonUtils;

public class AvroWriter
implements Closeable {
    private final Map<String, Generator> _generatorMap;
    private final Schema _avroSchema;
    private final DataFileWriter<GenericData.Record> _recordWriter;

    public AvroWriter(File baseDir, int index, Map<String, Generator> generatorMap, org.apache.pinot.spi.data.Schema schema) throws IOException {
        this._generatorMap = generatorMap;
        this._avroSchema = AvroWriter.getAvroSchema(schema);
        this._recordWriter = new DataFileWriter((DatumWriter)new GenericDatumWriter(this._avroSchema));
        this._recordWriter.create(this._avroSchema, new File(baseDir, "part-" + index + ".avro"));
    }

    public static Schema getAvroSchema(org.apache.pinot.spi.data.Schema schema) {
        ObjectNode avroSchema = JsonUtils.newObjectNode();
        avroSchema.put("name", "data_gen_record");
        avroSchema.put("type", "record");
        ArrayNode fields = JsonUtils.newArrayNode();
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            ObjectNode jsonObject = AvroSchemaUtil.toAvroSchemaJsonObject((FieldSpec)fieldSpec);
            fields.add((JsonNode)jsonObject);
        }
        avroSchema.set("fields", (JsonNode)fields);
        return new Schema.Parser().parse(avroSchema.toString());
    }

    public void writeNext() throws IOException {
        GenericData.Record nextRecord = new GenericData.Record(this._avroSchema);
        for (String column : this._generatorMap.keySet()) {
            nextRecord.put(column, this._generatorMap.get(column).next());
        }
        this._recordWriter.append((Object)nextRecord);
    }

    @Override
    public void close() throws IOException {
        this._recordWriter.close();
    }
}

