/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.upload;

import java.io.File;
import java.util.concurrent.Executor;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.common.exception.InvalidConfigException;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.util.TableSizeReader;
import org.apache.pinot.controller.validation.StorageQuotaChecker;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.utils.TimeUtils;
import org.joda.time.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentValidator.class);
    private final PinotHelixResourceManager _pinotHelixResourceManager;
    private final ControllerConf _controllerConf;
    private final Executor _executor;
    private final HttpConnectionManager _connectionManager;
    private final ControllerMetrics _controllerMetrics;
    private final boolean _isLeaderForTable;

    public SegmentValidator(PinotHelixResourceManager pinotHelixResourceManager, ControllerConf controllerConf, Executor executor, HttpConnectionManager connectionManager, ControllerMetrics controllerMetrics, boolean isLeaderForTable) {
        this._pinotHelixResourceManager = pinotHelixResourceManager;
        this._controllerConf = controllerConf;
        this._executor = executor;
        this._connectionManager = connectionManager;
        this._controllerMetrics = controllerMetrics;
        this._isLeaderForTable = isLeaderForTable;
    }

    public void validateOfflineSegment(String offlineTableName, SegmentMetadata segmentMetadata, File tempSegmentDir) {
        StorageQuotaChecker.QuotaCheckerResponse quotaResponse;
        TableConfig offlineTableConfig = ZKMetadataProvider.getOfflineTableConfig(this._pinotHelixResourceManager.getPropertyStore(), (String)offlineTableName);
        if (offlineTableConfig == null) {
            throw new ControllerApplicationException(LOGGER, "Failed to find table config for table: " + offlineTableName, Response.Status.NOT_FOUND);
        }
        String segmentName = segmentMetadata.getName();
        try {
            quotaResponse = this.checkStorageQuota(tempSegmentDir, segmentMetadata, offlineTableConfig);
        }
        catch (InvalidConfigException e) {
            throw new ControllerApplicationException(LOGGER, "Quota check failed for segment: " + segmentName + " of table: " + offlineTableName + ", reason: " + e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (!quotaResponse._isSegmentWithinQuota) {
            throw new ControllerApplicationException(LOGGER, "Quota check failed for segment: " + segmentName + " of table: " + offlineTableName + ", reason: " + quotaResponse._reason, Response.Status.FORBIDDEN);
        }
        Interval timeInterval = segmentMetadata.getTimeInterval();
        if (timeInterval != null && !TimeUtils.isValidTimeInterval((Interval)timeInterval)) {
            throw new ControllerApplicationException(LOGGER, String.format("Invalid segment start/end time: %s (in millis: %d/%d) for segment: %s of table: %s, must be between: %s", timeInterval, timeInterval.getStartMillis(), timeInterval.getEndMillis(), segmentName, offlineTableName, TimeUtils.VALID_TIME_INTERVAL), Response.Status.NOT_ACCEPTABLE);
        }
    }

    private StorageQuotaChecker.QuotaCheckerResponse checkStorageQuota(File segmentFile, SegmentMetadata metadata, TableConfig offlineTableConfig) throws InvalidConfigException {
        if (!this._controllerConf.getEnableStorageQuotaCheck()) {
            return StorageQuotaChecker.success("Quota check is disabled");
        }
        TableSizeReader tableSizeReader = new TableSizeReader(this._executor, this._connectionManager, this._controllerMetrics, this._pinotHelixResourceManager);
        StorageQuotaChecker quotaChecker = new StorageQuotaChecker(offlineTableConfig, tableSizeReader, this._controllerMetrics, this._isLeaderForTable, this._pinotHelixResourceManager);
        return quotaChecker.isSegmentStorageWithinQuota(metadata.getName(), FileUtils.sizeOfDirectory((File)segmentFile), this._controllerConf.getServerAdminRequestTimeoutSeconds() * 1000);
    }
}

