/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.util.TableSizeReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Table"})
@Path(value="/")
public class TableSize {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableSize.class);
    @Inject
    ControllerConf _controllerConf;
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;
    @Inject
    Executor _executor;
    @Inject
    HttpConnectionManager _connectionManager;
    @Inject
    ControllerMetrics _controllerMetrics;

    @GET
    @Path(value="/tables/{tableName}/size")
    @Produces(value={"application/json"})
    @ApiOperation(value="Read table sizes", notes="Get table size details. Table size is the size of untarred segments including replication")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Table not found"), @ApiResponse(code=500, message="Internal server error")})
    public TableSizeReader.TableSizeDetails getTableSize(@ApiParam(value="Table name without type", required=true, example="myTable | myTable_OFFLINE") @PathParam(value="tableName") String tableName, @ApiParam(value="Get detailed information", required=false) @DefaultValue(value="true") @QueryParam(value="detailed") boolean detailed) {
        TableSizeReader tableSizeReader = new TableSizeReader(this._executor, this._connectionManager, this._controllerMetrics, this._pinotHelixResourceManager);
        TableSizeReader.TableSizeDetails tableSizeDetails = null;
        try {
            tableSizeDetails = tableSizeReader.getTableSizeDetails(tableName, this._controllerConf.getServerAdminRequestTimeoutSeconds() * 1000);
        }
        catch (Throwable t) {
            throw new ControllerApplicationException(LOGGER, String.format("Failed to read table size for %s", tableName), Response.Status.INTERNAL_SERVER_ERROR, t);
        }
        if (tableSizeDetails == null) {
            throw new ControllerApplicationException(LOGGER, "Table " + tableName + " not found", Response.Status.NOT_FOUND);
        }
        return tableSizeDetails;
    }
}

