/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.segment.local.utils.TableConfigUtils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Table"})
@Path(value="/")
public class PinotTableSegmentConfigs {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotTableSegmentConfigs.class);
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;

    @Deprecated
    @PUT
    @Path(value="/tables/{tableName}/segmentConfigs")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Update segments configuration", notes="Updates segmentsConfig section (validation and retention) of a table")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Table not found"), @ApiResponse(code=500, message="Internal server error")})
    public SuccessResponse put(@ApiParam(value="Table name", required=true) @PathParam(value="tableName") String tableName, String tableConfigString) {
        TableConfig tableConfig;
        try {
            tableConfig = (TableConfig)JsonUtils.stringToObject((String)tableConfigString, TableConfig.class);
            Schema schema = this._pinotHelixResourceManager.getSchemaForTableConfig(tableConfig);
            TableConfigUtils.validate((TableConfig)tableConfig, (Schema)schema);
        }
        catch (Exception e) {
            String msg = String.format("Invalid table config: %s", tableName);
            throw new ControllerApplicationException(LOGGER, msg, Response.Status.BAD_REQUEST, (Throwable)e);
        }
        try {
            this._pinotHelixResourceManager.updateSegmentsValidationAndRetentionConfigFor(tableConfig.getTableName(), tableConfig.getTableType(), tableConfig.getValidationConfig());
            return new SuccessResponse("Update segmentsConfig for table: " + tableName);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, String.format("Failed to update segments config for table: %s", tableName), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }
}

