/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.utils.config.InstanceUtils;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.StateType;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.PinotResourceManagerResponse;
import org.apache.pinot.spi.config.instance.Instance;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Instance"})
@Path(value="/")
public class PinotInstanceRestletResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotInstanceRestletResource.class);
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;

    @GET
    @Path(value="/instances")
    @Produces(value={"application/json"})
    @ApiOperation(value="List all instances")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal error")})
    public Instances getAllInstances() {
        return new Instances(this._pinotHelixResourceManager.getAllInstances());
    }

    @GET
    @Path(value="/instances/{instanceName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get instance information", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Instance not found"), @ApiResponse(code=500, message="Internal error")})
    public String getInstance(@ApiParam(value="Instance name", required=true, example="Server_a.b.com_20000 | Broker_my.broker.com_30000") @PathParam(value="instanceName") String instanceName) {
        InstanceConfig instanceConfig = this._pinotHelixResourceManager.getHelixInstanceConfig(instanceName);
        if (instanceConfig == null) {
            throw new ControllerApplicationException(LOGGER, "Instance " + instanceName + " not found", Response.Status.NOT_FOUND);
        }
        ObjectNode response = JsonUtils.newObjectNode();
        response.put("instanceName", instanceConfig.getInstanceName());
        response.put("hostName", instanceConfig.getHostName());
        response.put("enabled", instanceConfig.getInstanceEnabled());
        response.put("port", instanceConfig.getPort());
        response.set("tags", JsonUtils.objectToJsonNode((Object)instanceConfig.getTags()));
        response.set("pools", JsonUtils.objectToJsonNode((Object)instanceConfig.getRecord().getMapField("pool")));
        response.put("grpcPort", this.getGrpcPort(instanceConfig));
        response.put("adminPort", this.getAdminPort(instanceConfig));
        String queriesDisabled = instanceConfig.getRecord().getSimpleField("queriesDisabled");
        if ("true".equalsIgnoreCase(queriesDisabled)) {
            response.put("queriesDisabled", "true");
        }
        response.put("systemResourceInfo", JsonUtils.objectToJsonNode(this.getSystemResourceInfo(instanceConfig)));
        return response.toString();
    }

    private int getGrpcPort(InstanceConfig instanceConfig) {
        String grpcPortStr = instanceConfig.getRecord().getSimpleField("grpcPort");
        if (grpcPortStr != null) {
            try {
                return Integer.parseInt(grpcPortStr);
            }
            catch (Exception e) {
                LOGGER.warn("Illegal gRPC port: {} for instance: {}", (Object)grpcPortStr, (Object)instanceConfig.getInstanceName());
            }
        }
        return -1;
    }

    private int getAdminPort(InstanceConfig instanceConfig) {
        String adminPortStr = instanceConfig.getRecord().getSimpleField("adminPort");
        if (adminPortStr != null) {
            try {
                return Integer.parseInt(adminPortStr);
            }
            catch (Exception e) {
                LOGGER.warn("Illegal admin port: {} for instance: {}", (Object)adminPortStr, (Object)instanceConfig.getInstanceName());
            }
        }
        return -1;
    }

    private Map<String, String> getSystemResourceInfo(InstanceConfig instanceConfig) {
        return instanceConfig.getRecord().getMapField("SYSTEM_RESOURCE_INFO");
    }

    @POST
    @Path(value="/instances")
    @Authenticate(value=AccessType.CREATE)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new instance", consumes="application/json", notes="Creates a new instance with given instance config")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=409, message="Instance already exists"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse addInstance(@ApiParam(value="Whether to update broker resource for broker instance") @QueryParam(value="updateBrokerResource") @DefaultValue(value="false") boolean updateBrokerResource, Instance instance) {
        String instanceId = InstanceUtils.getHelixInstanceId((Instance)instance);
        LOGGER.info("Instance creation request received for instance: {}, updateBrokerResource: {}", (Object)instanceId, (Object)updateBrokerResource);
        try {
            PinotResourceManagerResponse response = this._pinotHelixResourceManager.addInstance(instance, updateBrokerResource);
            return new SuccessResponse(response.getMessage());
        }
        catch (ClientErrorException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), e.getResponse().getStatus());
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Failed to create instance: " + instanceId, Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @POST
    @Path(value="/instances/{instanceName}/state")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Enable/disable/drop an instance", notes="Enable/disable/drop an instance")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=404, message="Instance not found"), @ApiResponse(code=409, message="Instance cannot be dropped"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse toggleInstanceState(@ApiParam(value="Instance name", required=true, example="Server_a.b.com_20000 | Broker_my.broker.com_30000") @PathParam(value="instanceName") String instanceName, String state) {
        if (!this._pinotHelixResourceManager.instanceExists(instanceName)) {
            throw new ControllerApplicationException(LOGGER, "Instance " + instanceName + " not found", Response.Status.NOT_FOUND);
        }
        if (StateType.ENABLE.name().equalsIgnoreCase(state)) {
            PinotResourceManagerResponse response = this._pinotHelixResourceManager.enableInstance(instanceName);
            if (!response.isSuccessful()) {
                throw new ControllerApplicationException(LOGGER, "Failed to enable instance " + instanceName + " - " + response.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
            }
        } else if (StateType.DISABLE.name().equalsIgnoreCase(state)) {
            PinotResourceManagerResponse response = this._pinotHelixResourceManager.disableInstance(instanceName);
            if (!response.isSuccessful()) {
                throw new ControllerApplicationException(LOGGER, "Failed to disable instance " + instanceName + " - " + response.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
            }
        } else if (StateType.DROP.name().equalsIgnoreCase(state)) {
            PinotResourceManagerResponse response = this._pinotHelixResourceManager.dropInstance(instanceName);
            if (!response.isSuccessful()) {
                throw new ControllerApplicationException(LOGGER, "Failed to drop instance " + instanceName + " - " + response.getMessage(), Response.Status.CONFLICT);
            }
        } else {
            throw new ControllerApplicationException(LOGGER, "Unknown state " + state + " for instance request", Response.Status.BAD_REQUEST);
        }
        return new SuccessResponse("Request to " + state + " instance " + instanceName + " is successful");
    }

    @DELETE
    @Path(value="/instances/{instanceName}")
    @Authenticate(value=AccessType.DELETE)
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Drop an instance", notes="Drop an instance")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Instance not found"), @ApiResponse(code=409, message="Instance cannot be dropped"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse dropInstance(@ApiParam(value="Instance name", required=true, example="Server_a.b.com_20000 | Broker_my.broker.com_30000") @PathParam(value="instanceName") String instanceName) {
        if (!this._pinotHelixResourceManager.instanceExists(instanceName)) {
            throw new ControllerApplicationException(LOGGER, "Instance " + instanceName + " not found", Response.Status.NOT_FOUND);
        }
        PinotResourceManagerResponse response = this._pinotHelixResourceManager.dropInstance(instanceName);
        if (!response.isSuccessful()) {
            throw new ControllerApplicationException(LOGGER, "Failed to drop instance " + instanceName + " - " + response.getMessage(), Response.Status.CONFLICT);
        }
        return new SuccessResponse("Successfully dropped instance");
    }

    @PUT
    @Path(value="/instances/{instanceName}")
    @Authenticate(value=AccessType.UPDATE)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update the specified instance", consumes="application/json", notes="Update specified instance with given instance config")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse updateInstance(@ApiParam(value="Instance name", required=true, example="Server_a.b.com_20000 | Broker_my.broker.com_30000") @PathParam(value="instanceName") String instanceName, @ApiParam(value="Whether to update broker resource for broker instance") @QueryParam(value="updateBrokerResource") @DefaultValue(value="false") boolean updateBrokerResource, Instance instance) {
        LOGGER.info("Instance update request received for instance: {}, updateBrokerResource: {}", (Object)instanceName, (Object)updateBrokerResource);
        try {
            PinotResourceManagerResponse response = this._pinotHelixResourceManager.updateInstance(instanceName, instance, updateBrokerResource);
            return new SuccessResponse(response.getMessage());
        }
        catch (ClientErrorException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), e.getResponse().getStatus());
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Failed to update instance: " + instanceName, Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @PUT
    @Path(value="/instances/{instanceName}/updateTags")
    @Authenticate(value=AccessType.UPDATE)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update the tags of the specified instance", consumes="application/json", notes="Update the tags of the specified instance")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=404, message="Instance not found"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse updateInstanceTags(@ApiParam(value="Instance name", required=true, example="Server_a.b.com_20000 | Broker_my.broker.com_30000") @PathParam(value="instanceName") String instanceName, @ApiParam(value="Comma separated tags list", required=true) @QueryParam(value="tags") String tags, @ApiParam(value="Whether to update broker resource for broker instance") @QueryParam(value="updateBrokerResource") @DefaultValue(value="false") boolean updateBrokerResource) {
        LOGGER.info("Instance update request received for instance: {}, tags: {}, updateBrokerResource: {}", new Object[]{instanceName, tags, updateBrokerResource});
        if (tags == null) {
            throw new ControllerApplicationException(LOGGER, "Must provide tags to update", Response.Status.BAD_REQUEST);
        }
        try {
            PinotResourceManagerResponse response = this._pinotHelixResourceManager.updateInstanceTags(instanceName, tags, updateBrokerResource);
            return new SuccessResponse(response.getMessage());
        }
        catch (ClientErrorException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), e.getResponse().getStatus());
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, String.format("Failed to update instance: %s with tags: %s", instanceName, tags), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @POST
    @Path(value="/instances/{instanceName}/updateBrokerResource")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Update the tables served by the specified broker instance in the broker resource", notes="Broker resource should be updated when a new broker instance is added, or the tags for an existing broker are changed. Updating broker resource requires reading all the table configs, which can be costly for large cluster. Consider updating broker resource for each table individually.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=404, message="Instance not found"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse updateBrokerResource(@ApiParam(value="Instance name", required=true, example="Broker_my.broker.com_30000") @PathParam(value="instanceName") String instanceName) {
        LOGGER.info("Update broker resource request received for instance: {}", (Object)instanceName);
        try {
            PinotResourceManagerResponse response = this._pinotHelixResourceManager.updateBrokerResource(instanceName);
            return new SuccessResponse(response.getMessage());
        }
        catch (ClientErrorException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), e.getResponse().getStatus());
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Failed to update broker resource for instance: " + instanceName, Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    public static class Instances {
        List<String> _instances;

        public Instances(@JsonProperty(value="instances") List<String> instances) {
            this._instances = instances;
        }

        public List<String> getInstances() {
            return this._instances;
        }
    }
}

