/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import java.io.IOException;
import javax.inject.Singleton;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.apache.pinot.common.Utils;
import org.apache.pinot.spi.utils.NetUtils;

@Singleton
@Provider
public class PinotControllerResponseFilter
implements ContainerResponseFilter {
    private static final String CONTROLLER_COMPONENT = "pinot-controller";
    private static final String UNKNOWN = "Unknown";
    private final String _controllerHost;
    private final String _controllerVersion;

    public PinotControllerResponseFilter() {
        String controllerHost = NetUtils.getHostnameOrAddress();
        this._controllerHost = controllerHost != null ? controllerHost : UNKNOWN;
        String controllerVersion = (String)Utils.getComponentVersions().get(CONTROLLER_COMPONENT);
        this._controllerVersion = controllerVersion != null ? controllerVersion : UNKNOWN;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        responseContext.getHeaders().putSingle((Object)"Pinot-Controller-Host", (Object)this._controllerHost);
        responseContext.getHeaders().putSingle((Object)"Pinot-Controller-Version", (Object)this._controllerVersion);
    }
}

