/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.common.utils.ServiceStatus;
import org.apache.pinot.controller.ControllerConf;

@Api(tags={"Health"})
@Path(value="/")
public class PinotControllerHealthCheck {
    @Inject
    @Named(value="controllerInstanceId")
    private String _instanceId;
    @Inject
    ControllerConf _controllerConf;
    @Inject
    private ControllerMetrics _controllerMetrics;

    @GET
    @Path(value="pinot-controller/admin")
    @ApiOperation(value="Check controller health")
    @ApiResponses(value={@ApiResponse(code=200, message="Good")})
    @Produces(value={"text/plain"})
    public String checkHealthLegacy() {
        if (StringUtils.isNotBlank((String)this._controllerConf.generateVipUrl())) {
            return "GOOD";
        }
        return "";
    }

    @GET
    @Path(value="health")
    @ApiOperation(value="Check controller health")
    @ApiResponses(value={@ApiResponse(code=200, message="Good")})
    @Produces(value={"text/plain"})
    public String checkHealth() {
        ServiceStatus.Status status = ServiceStatus.getServiceStatus((String)this._instanceId);
        if (status == ServiceStatus.Status.GOOD) {
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.HEALTHCHECK_OK_CALLS, 1L);
            return "OK";
        }
        this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.HEALTHCHECK_BAD_CALLS, 1L);
        String errMessage = String.format("Pinot controller status is %s", status);
        Response response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)errMessage).build();
        throw new WebApplicationException(errMessage, response);
    }
}

