/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.sql.parsers.rewriter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlKind;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.Identifier;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.sql.parsers.SqlCompilationException;
import org.apache.pinot.sql.parsers.rewriter.QueryRewriter;

public class AliasApplier
implements QueryRewriter {
    @Override
    public PinotQuery rewrite(PinotQuery pinotQuery) {
        Map<Identifier, Expression> aliasMap = AliasApplier.extractAlias(pinotQuery.getSelectList());
        AliasApplier.applyAlias(aliasMap, pinotQuery);
        AliasApplier.validateSelectionClause(aliasMap, pinotQuery);
        return pinotQuery;
    }

    private static Map<Identifier, Expression> extractAlias(List<Expression> expressions) {
        HashMap<Identifier, Expression> aliasMap = new HashMap<Identifier, Expression>();
        for (Expression expression : expressions) {
            Function functionCall = expression.getFunctionCall();
            if (functionCall == null || !functionCall.getOperator().equalsIgnoreCase(SqlKind.AS.toString())) continue;
            Expression identifierExpr = functionCall.getOperands().get(1);
            aliasMap.put(identifierExpr.getIdentifier(), functionCall.getOperands().get(0));
        }
        return aliasMap;
    }

    private static void applyAlias(Map<Identifier, Expression> aliasMap, PinotQuery pinotQuery) {
        List<Expression> orderByList;
        Expression havingExpression;
        List<Expression> groupByList;
        Expression filterExpression = pinotQuery.getFilterExpression();
        if (filterExpression != null) {
            AliasApplier.applyAlias(aliasMap, filterExpression);
        }
        if ((groupByList = pinotQuery.getGroupByList()) != null) {
            for (Expression expression : groupByList) {
                AliasApplier.applyAlias(aliasMap, expression);
            }
        }
        if ((havingExpression = pinotQuery.getHavingExpression()) != null) {
            AliasApplier.applyAlias(aliasMap, havingExpression);
        }
        if ((orderByList = pinotQuery.getOrderByList()) != null) {
            for (Expression expression : orderByList) {
                AliasApplier.applyAlias(aliasMap, expression);
            }
        }
    }

    private static void applyAlias(Map<Identifier, Expression> aliasMap, Expression expression) {
        Identifier identifierKey = expression.getIdentifier();
        if (identifierKey != null) {
            Expression aliasExpression = aliasMap.get(identifierKey);
            if (aliasExpression != null) {
                expression.setType(aliasExpression.getType());
                expression.setIdentifier(aliasExpression.getIdentifier());
                expression.setFunctionCall(aliasExpression.getFunctionCall());
                expression.setLiteral(aliasExpression.getLiteral());
            }
            return;
        }
        Function function = expression.getFunctionCall();
        if (function != null) {
            for (Expression operand : function.getOperands()) {
                AliasApplier.applyAlias(aliasMap, operand);
            }
        }
    }

    private static void validateSelectionClause(Map<Identifier, Expression> aliasMap, PinotQuery pinotQuery) throws SqlCompilationException {
        HashSet<String> aliasKeys = new HashSet<String>();
        for (Identifier identifier : aliasMap.keySet()) {
            String aliasName = identifier.getName().toLowerCase();
            if (aliasKeys.add(aliasName)) continue;
            throw new SqlCompilationException("Duplicated alias name found.");
        }
    }
}

