/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.pql.parsers.pql2.ast;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.pql.parsers.Pql2CompilationException;
import org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.pql.parsers.pql2.ast.FilterKind;
import org.apache.pinot.pql.parsers.pql2.ast.FunctionCallAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.IdentifierAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.PredicateAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.StringLiteralAstNode;

public class TextMatchPredicateAstNode
extends PredicateAstNode {
    @Override
    public void addChild(AstNode childNode) {
        if (childNode instanceof IdentifierAstNode) {
            if (this._identifier != null) {
                throw new Pql2CompilationException("TEXT_MATCH predicate has more than one column");
            }
            this._identifier = ((IdentifierAstNode)childNode).getName();
        } else {
            if (childNode instanceof FunctionCallAstNode) {
                throw new Pql2CompilationException("TEXT_MATCH predicate cannot be applied to function");
            }
            super.addChild(childNode);
        }
    }

    @Override
    public FilterQueryTree buildFilterQueryTree() {
        if (this._identifier == null) {
            throw new Pql2CompilationException("TEXT_MATCH predicate has no identifier");
        }
        List<? extends AstNode> children = this.getChildren();
        Preconditions.checkState((children != null && children.size() == 1 ? 1 : 0) != 0, (Object)"TEXT_MATCH predicate should have exactly one query string");
        AstNode child = children.get(0);
        Preconditions.checkState((boolean)(child instanceof StringLiteralAstNode));
        String expr = ((StringLiteralAstNode)child).getValueAsString();
        FilterOperator filterOperator = FilterOperator.TEXT_MATCH;
        List<String> value = Collections.singletonList(expr);
        return new FilterQueryTree(this._identifier, value, filterOperator, null);
    }

    @Override
    public Expression buildFilterExpression() {
        if (this._identifier == null) {
            throw new Pql2CompilationException("TEXT_MATCH predicate has no identifier");
        }
        Expression expression = RequestUtils.getFunctionExpression(FilterKind.TEXT_MATCH.name());
        Function function = expression.getFunctionCall();
        function.addToOperands(RequestUtils.createIdentifierExpression(this._identifier));
        List<? extends AstNode> children = this.getChildren();
        if (children.size() != 1) {
            throw new Pql2CompilationException("TEXT_MATCH predicate should have exactly one query string");
        }
        function.addToOperands(RequestUtils.getExpression(children.get(0)));
        return expression;
    }
}

