/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.pql.parsers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.apache.calcite.sql.SqlKind;
import org.apache.pinot.common.function.FunctionDefinitionRegistry;
import org.apache.pinot.common.request.AggregationInfo;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.DataSource;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.request.FilterQuery;
import org.apache.pinot.common.request.FilterQueryMap;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.GroupBy;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.request.QuerySource;
import org.apache.pinot.common.request.Selection;
import org.apache.pinot.common.request.SelectionSort;
import org.apache.pinot.parsers.utils.ParserUtils;
import org.apache.pinot.pql.parsers.Pql2CompilationException;
import org.apache.pinot.pql.parsers.pql2.ast.FilterKind;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class PinotQuery2BrokerRequestConverter {
    public BrokerRequest convert(PinotQuery pinotQuery) {
        BrokerRequest brokerRequest = new BrokerRequest();
        DataSource dataSource = pinotQuery.getDataSource();
        if (dataSource != null) {
            QuerySource querySource = new QuerySource();
            querySource.setTableName(dataSource.getTableName());
            brokerRequest.setQuerySource(querySource);
        }
        this.convertFilter(pinotQuery, brokerRequest);
        this.convertSelectList(pinotQuery, brokerRequest);
        this.convertOrderBy(pinotQuery, brokerRequest);
        this.convertGroupBy(pinotQuery, brokerRequest);
        brokerRequest.setDebugOptions(pinotQuery.getDebugOptions());
        brokerRequest.setQueryOptions(pinotQuery.getQueryOptions());
        brokerRequest.setLimit(pinotQuery.getLimit());
        brokerRequest.setPinotQuery(pinotQuery);
        return brokerRequest;
    }

    private void convertOrderBy(PinotQuery pinotQuery, BrokerRequest brokerRequest) {
        if (pinotQuery.getOrderByList() == null) {
            return;
        }
        ArrayList<SelectionSort> sortSequenceList = new ArrayList<SelectionSort>();
        List<Expression> orderByList = pinotQuery.getOrderByList();
        for (Expression orderByExpr : orderByList) {
            SelectionSort selectionSort = new SelectionSort();
            Function functionCall = orderByExpr.getFunctionCall();
            selectionSort.setIsAsc(functionCall.getOperator().equalsIgnoreCase("asc"));
            selectionSort.setColumn(ParserUtils.standardizeExpression(functionCall.getOperands().get(0), true));
            sortSequenceList.add(selectionSort);
        }
        if (!sortSequenceList.isEmpty()) {
            if (brokerRequest.getSelections() != null) {
                brokerRequest.getSelections().setSelectionSortSequence(sortSequenceList);
            }
            brokerRequest.setOrderBy(sortSequenceList);
        }
    }

    private void convertGroupBy(PinotQuery pinotQuery, BrokerRequest brokerRequest) {
        List<Expression> groupByList = pinotQuery.getGroupByList();
        if (groupByList != null && !groupByList.isEmpty()) {
            GroupBy groupBy = new GroupBy();
            for (Expression expression : groupByList) {
                String expressionStr = ParserUtils.standardizeExpression(expression, true);
                groupBy.addToExpressions(expressionStr);
            }
            groupBy.setTopN(pinotQuery.getLimit());
            brokerRequest.setGroupBy(groupBy);
        }
    }

    private void convertSelectList(PinotQuery pinotQuery, BrokerRequest brokerRequest) {
        Selection selection = null;
        ArrayList<AggregationInfo> aggregationInfoList = null;
        block5: for (Expression selectExpression : pinotQuery.getSelectList()) {
            Expression expression;
            ExpressionType type = selectExpression.getType();
            if (type == ExpressionType.FUNCTION && selectExpression.getFunctionCall().getOperator().equalsIgnoreCase(SqlKind.AS.toString())) {
                expression = selectExpression.getFunctionCall().getOperands().get(0);
                type = expression.getType();
            } else {
                expression = selectExpression;
            }
            switch (type) {
                case LITERAL: {
                    if (selection == null) {
                        selection = new Selection();
                    }
                    selection.addToSelectionColumns('\'' + expression.getLiteral().getFieldValue().toString() + '\'');
                    continue block5;
                }
                case IDENTIFIER: {
                    if (selection == null) {
                        selection = new Selection();
                    }
                    selection.addToSelectionColumns(expression.getIdentifier().getName());
                    continue block5;
                }
                case FUNCTION: {
                    Function functionCall = expression.getFunctionCall();
                    String functionName = functionCall.getOperator();
                    if (FunctionDefinitionRegistry.isAggFunc(functionName)) {
                        AggregationInfo aggInfo = this.buildAggregationInfo(functionCall);
                        if (aggregationInfoList == null) {
                            aggregationInfoList = new ArrayList<AggregationInfo>();
                        }
                        aggregationInfoList.add(aggInfo);
                        continue block5;
                    }
                    if (selection == null) {
                        selection = new Selection();
                    }
                    selection.addToSelectionColumns(ParserUtils.standardizeExpression(expression, false));
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unrecognized expression type - " + (Object)((Object)type));
        }
        if (aggregationInfoList != null && !aggregationInfoList.isEmpty()) {
            brokerRequest.setAggregationsInfo((List<AggregationInfo>)aggregationInfoList);
        } else if (selection != null) {
            if (pinotQuery.isSetOffset()) {
                selection.setOffset(pinotQuery.getOffset());
            }
            if (pinotQuery.isSetLimit()) {
                selection.setSize(pinotQuery.getLimit());
            }
            brokerRequest.setSelections(selection);
        }
    }

    private void convertFilter(PinotQuery pinotQuery, BrokerRequest brokerRequest) {
        Expression filterExpression = pinotQuery.getFilterExpression();
        if (filterExpression != null) {
            FilterQueryMap filterSubQueryMap = new FilterQueryMap();
            FilterQuery filterQuery = this.traverseFilterExpression(filterExpression, filterSubQueryMap);
            brokerRequest.setFilterQuery(filterQuery);
            brokerRequest.setFilterSubQueryMap(filterSubQueryMap);
        }
    }

    private AggregationInfo buildAggregationInfo(Function function) {
        List<Expression> operands = function.getOperands();
        if (operands == null || operands.isEmpty()) {
            throw new Pql2CompilationException("Aggregation function expects non null argument");
        }
        ArrayList<String> args = new ArrayList(operands.size());
        String functionName = function.getOperator();
        if (functionName.equalsIgnoreCase(AggregationFunctionType.COUNT.getName())) {
            args = Collections.singletonList("*");
        } else if (functionName.equalsIgnoreCase(AggregationFunctionType.DISTINCT.getName())) {
            TreeSet expressionSet = new TreeSet();
            for (Expression operand : operands) {
                String expression = this.getColumnExpression(operand);
                if (!expressionSet.add(expression)) continue;
                args.add(expression);
            }
        } else {
            for (Expression operand : operands) {
                args.add(this.getColumnExpression(operand));
            }
        }
        AggregationInfo aggregationInfo = new AggregationInfo();
        aggregationInfo.setAggregationType(functionName);
        aggregationInfo.setExpressions(args);
        aggregationInfo.setIsInSelectList(true);
        aggregationInfo.putToAggregationParams("column", String.join((CharSequence)":", args));
        return aggregationInfo;
    }

    private String getColumnExpression(Expression functionParam) {
        switch (functionParam.getType()) {
            case LITERAL: {
                return functionParam.getLiteral().getFieldValue().toString();
            }
            case IDENTIFIER: {
                return functionParam.getIdentifier().getName();
            }
            case FUNCTION: {
                return ParserUtils.standardizeExpression(functionParam, false, true);
            }
        }
        throw new UnsupportedOperationException("Unrecognized functionParamType:" + (Object)((Object)functionParam.getType()));
    }

    private FilterQuery traverseFilterExpression(Expression filterExpression, FilterQueryMap filterSubQueryMap) {
        FilterQuery filterQuery = new FilterQuery();
        int id = filterSubQueryMap.getFilterQueryMapSize();
        filterQuery.setId(id);
        filterSubQueryMap.putToFilterQueryMap(id, filterQuery);
        ArrayList<Integer> childFilterIds = new ArrayList<Integer>();
        ExpressionType filterExpressionType = filterExpression.getType();
        block0 : switch (filterExpressionType) {
            case LITERAL: 
            case IDENTIFIER: {
                break;
            }
            case FUNCTION: {
                FilterKind filterKind = ParserUtils.getFilterKind(filterExpression);
                FilterOperator filterOperator = ParserUtils.filterKindToOperator(filterKind);
                filterQuery.setOperator(filterOperator);
                Function functionCall = filterExpression.getFunctionCall();
                List<Expression> operands = functionCall.getOperands();
                switch (filterOperator) {
                    case AND: 
                    case OR: {
                        for (Expression operand : operands) {
                            FilterQuery childFilter = this.traverseFilterExpression(operand, filterSubQueryMap);
                            childFilterIds.add(childFilter.getId());
                        }
                        break block0;
                    }
                    case EQUALITY: 
                    case NOT: 
                    case RANGE: 
                    case REGEXP_LIKE: 
                    case NOT_IN: 
                    case IN: 
                    case TEXT_MATCH: 
                    case JSON_MATCH: {
                        filterQuery.setColumn(ParserUtils.standardizeExpression(operands.get(0), false));
                        filterQuery.setValue(ParserUtils.getFilterValues(filterKind, operands));
                        break block0;
                    }
                    case IS_NULL: 
                    case IS_NOT_NULL: {
                        filterQuery.setColumn(ParserUtils.standardizeExpression(operands.get(0), false));
                        break block0;
                    }
                    default: {
                        throw new UnsupportedOperationException("Filter UDF not supported");
                    }
                }
            }
            default: {
                throw new IllegalArgumentException("Unrecognized filter expression type - " + (Object)((Object)filterExpressionType));
            }
        }
        filterQuery.setNestedFilterQueryIds(childFilterIds);
        return filterQuery;
    }
}

