/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.request;

import java.util.List;
import org.apache.pinot.common.request.FilterOperator;

public class FilterQueryTree {
    private final String _column;
    private final List<String> _value;
    private final FilterOperator _operator;
    private final List<FilterQueryTree> _children;

    public FilterQueryTree(String column, List<String> value, FilterOperator operator, List<FilterQueryTree> children) {
        this._column = column;
        this._value = value;
        this._operator = operator;
        this._children = children;
    }

    public String getColumn() {
        return this._column;
    }

    public List<String> getValue() {
        return this._value;
    }

    public FilterOperator getOperator() {
        return this._operator;
    }

    public List<FilterQueryTree> getChildren() {
        return this._children;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.recursiveToStringIntoBuffer(0, stringBuffer);
        return stringBuffer.toString();
    }

    private void recursiveToStringIntoBuffer(int indent, StringBuffer stringBuffer) {
        for (int i = 0; i < indent; ++i) {
            stringBuffer.append(' ');
        }
        if (this._operator == FilterOperator.OR || this._operator == FilterOperator.AND) {
            stringBuffer.append((Object)this._operator);
            for (FilterQueryTree child : this._children) {
                stringBuffer.append('\n');
                child.recursiveToStringIntoBuffer(indent + 1, stringBuffer);
            }
        } else {
            stringBuffer.append(this._column).append(' ').append((Object)this._operator).append(' ').append(this._value);
        }
    }
}

