/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.helix;

import org.apache.helix.AccessOption;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.zk.ZkHelixPropertyStore;

public class PinotHelixPropertyStoreZnRecordProvider {
    private final ZkHelixPropertyStore<ZNRecord> _propertyStore;
    private final String _pathPrefix;

    private PinotHelixPropertyStoreZnRecordProvider() {
        this._pathPrefix = null;
        this._propertyStore = null;
    }

    private PinotHelixPropertyStoreZnRecordProvider(ZkHelixPropertyStore<ZNRecord> propertyStore, String relativePathName) {
        this._propertyStore = propertyStore;
        this._pathPrefix = relativePathName;
    }

    public static PinotHelixPropertyStoreZnRecordProvider forSchema(ZkHelixPropertyStore<ZNRecord> propertyStore) {
        return new PinotHelixPropertyStoreZnRecordProvider(propertyStore, "/SCHEMAS");
    }

    public static PinotHelixPropertyStoreZnRecordProvider forTable(ZkHelixPropertyStore<ZNRecord> propertyStore) {
        return new PinotHelixPropertyStoreZnRecordProvider(propertyStore, "/CONFIGS/TABLES");
    }

    public static PinotHelixPropertyStoreZnRecordProvider forSegments(ZkHelixPropertyStore<ZNRecord> propertyStore) {
        return new PinotHelixPropertyStoreZnRecordProvider(propertyStore, "/SEGMENTS");
    }

    public ZNRecord get(String name) {
        return (ZNRecord)this._propertyStore.get(this._pathPrefix + "/" + name, null, AccessOption.PERSISTENT);
    }

    public void set(String name, ZNRecord record) {
        this._propertyStore.set(this._pathPrefix + "/" + name, (Object)record, AccessOption.PERSISTENT);
    }

    public boolean exist(String path) {
        return this._propertyStore.exists(this._pathPrefix + "/" + path, AccessOption.PERSISTENT);
    }

    public String getRelativePath() {
        return this._pathPrefix;
    }
}

