/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.grpc;

import io.grpc.Channel;
import io.grpc.ManagedChannelBuilder;
import java.util.Iterator;
import org.apache.pinot.common.proto.PinotQueryServerGrpc;
import org.apache.pinot.common.proto.Server;

public class GrpcQueryClient {
    private final PinotQueryServerGrpc.PinotQueryServerBlockingStub _blockingStub;

    public GrpcQueryClient(String host, int port) {
        this(host, port, new Config());
    }

    public GrpcQueryClient(String host, int port, Config config) {
        ManagedChannelBuilder managedChannelBuilder = ManagedChannelBuilder.forAddress((String)host, (int)port).maxInboundMessageSize(config.getMaxInboundMessageSizeBytes());
        if (config.isUsePlainText()) {
            managedChannelBuilder.usePlaintext();
        }
        this._blockingStub = PinotQueryServerGrpc.newBlockingStub((Channel)managedChannelBuilder.build());
    }

    public Iterator<Server.ServerResponse> submit(Server.ServerRequest request) {
        return this._blockingStub.submit(request);
    }

    public static class Config {
        private static final int DEFAULT_MAX_INBOUND_MESSAGE_BYTES_SIZE = 0x8000000;
        private final int _maxInboundMessageSizeBytes;
        private final boolean _usePlainText;

        public Config() {
            this(0x8000000, true);
        }

        public Config(int maxInboundMessageSizeBytes, boolean usePlainText) {
            this._maxInboundMessageSizeBytes = maxInboundMessageSizeBytes;
            this._usePlainText = usePlainText;
        }

        public int getMaxInboundMessageSizeBytes() {
            return this._maxInboundMessageSizeBytes;
        }

        public boolean isUsePlainText() {
            return this._usePlainText;
        }
    }
}

