/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

public class RegexpPatternConverterUtils {
    public static final String[] REGEXP_METACHARACTERS = new String[]{"\\", "^", "$", ".", "{", "}", "[", "]", "(", ")", "*", "+", "?", "|", "<", ">", "-", "&", "/"};

    private RegexpPatternConverterUtils() {
    }

    public static String likeToRegexpLike(String likePattern) {
        return "^" + RegexpPatternConverterUtils.escapeMetaCharacters(likePattern).replace('_', '.').replace("%", ".*") + "$";
    }

    private static String escapeMetaCharacters(String pattern) {
        for (String metaCharacter : REGEXP_METACHARACTERS) {
            if (!pattern.contains(metaCharacter)) continue;
            pattern = pattern.replace(metaCharacter, "\\" + metaCharacter);
        }
        return pattern;
    }

    public static String regexpLikeToLuceneRegExp(String regexpLikePattern) {
        if (regexpLikePattern.isEmpty()) {
            return regexpLikePattern;
        }
        regexpLikePattern = regexpLikePattern.charAt(0) == '^' ? regexpLikePattern.substring(1) : ".*" + regexpLikePattern;
        int length = regexpLikePattern.length();
        regexpLikePattern = regexpLikePattern.charAt(length - 1) == '$' ? regexpLikePattern.substring(0, length - 1) : regexpLikePattern + ".*";
        return regexpLikePattern;
    }
}

