/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.pinot.common.Utils;
import org.apache.pinot.common.metrics.PinotMetricUtils;
import org.apache.pinot.spi.metrics.PinotMeter;
import org.apache.pinot.spi.metrics.PinotMetricName;
import org.apache.pinot.spi.metrics.PinotMetricsRegistry;
import org.apache.pinot.spi.metrics.PinotTimer;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetrics<QP extends QueryPhase, M extends Meter, G extends Gauge, T extends Timer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMetrics.class);
    protected final String _metricPrefix;
    protected final PinotMetricsRegistry _metricsRegistry;
    private final Class _clazz;
    private final Map<String, AtomicLong> _gaugeValues = new ConcurrentHashMap<String, AtomicLong>();
    private final boolean _isTableLevelMetricsEnabled;
    private final Set<String> _allowedTables;

    public AbstractMetrics(String metricPrefix, PinotMetricsRegistry metricsRegistry, Class clazz) {
        this(metricPrefix, metricsRegistry, clazz, true, Collections.emptySet());
    }

    public AbstractMetrics(String metricPrefix, PinotMetricsRegistry metricsRegistry, Class clazz, boolean isTableLevelMetricsEnabled, Collection<String> allowedTables) {
        this._metricPrefix = metricPrefix;
        this._metricsRegistry = metricsRegistry;
        this._clazz = clazz;
        this._isTableLevelMetricsEnabled = isTableLevelMetricsEnabled;
        this._allowedTables = AbstractMetrics.addNameVariations(allowedTables);
    }

    private static Set<String> addNameVariations(Collection<String> allowedTables) {
        return allowedTables.stream().flatMap(tableName -> TableNameBuilder.getTableNameVariations((String)tableName).stream()).collect(Collectors.toCollection(HashSet::new));
    }

    public PinotMetricsRegistry getMetricsRegistry() {
        return this._metricsRegistry;
    }

    public void addPhaseTiming(String tableName, QP phase, long duration, TimeUnit timeUnit) {
        String fullTimerName = this._metricPrefix + this.getTableName(tableName) + "." + phase.getQueryPhaseName();
        this.addValueToTimer(fullTimerName, duration, timeUnit);
    }

    public void addPhaseTiming(String tableName, QP phase, long nanos) {
        this.addPhaseTiming(tableName, phase, nanos, TimeUnit.NANOSECONDS);
    }

    public void addTimedTableValue(String tableName, T timer, long duration, TimeUnit timeUnit) {
        String fullTimerName = this._metricPrefix + this.getTableName(tableName) + "." + timer.getTimerName();
        this.addValueToTimer(fullTimerName, duration, timeUnit);
    }

    public void addTimedValue(T timer, long duration, TimeUnit timeUnit) {
        String fullTimerName = this._metricPrefix + timer.getTimerName();
        this.addValueToTimer(fullTimerName, duration, timeUnit);
    }

    private void addValueToTimer(String fullTimerName, long duration, TimeUnit timeUnit) {
        PinotMetricName metricName = PinotMetricUtils.makePinotMetricName(this._clazz, fullTimerName);
        PinotTimer timer = PinotMetricUtils.makePinotTimer(this._metricsRegistry, metricName, TimeUnit.MILLISECONDS, TimeUnit.SECONDS);
        if (timer != null) {
            timer.update(duration, timeUnit);
        }
    }

    public void addMeteredGlobalValue(M meter, long unitCount) {
        this.addMeteredGlobalValue(meter, unitCount, null);
    }

    public PinotMeter addMeteredGlobalValue(M meter, long unitCount, PinotMeter reusedMeter) {
        if (reusedMeter != null) {
            reusedMeter.mark(unitCount);
            return reusedMeter;
        }
        String meterName = meter.getMeterName();
        String fullMeterName = this._metricPrefix + meterName;
        PinotMetricName metricName = PinotMetricUtils.makePinotMetricName(this._clazz, fullMeterName);
        PinotMeter newMeter = PinotMetricUtils.makePinotMeter(this._metricsRegistry, metricName, meter.getUnit(), TimeUnit.SECONDS);
        newMeter.mark(unitCount);
        return newMeter;
    }

    public void addMeteredTableValue(String tableName, M meter, long unitCount) {
        this.addMeteredTableValue(tableName, meter, unitCount, null);
    }

    public PinotMeter addMeteredTableValue(String tableName, M meter, long unitCount, PinotMeter reusedMeter) {
        if (reusedMeter != null) {
            reusedMeter.mark(unitCount);
            return reusedMeter;
        }
        String meterName = meter.getMeterName();
        String fullMeterName = this._metricPrefix + this.getTableName(tableName) + "." + meterName;
        PinotMetricName metricName = PinotMetricUtils.makePinotMetricName(this._clazz, fullMeterName);
        PinotMeter newMeter = PinotMetricUtils.makePinotMeter(this._metricsRegistry, metricName, meter.getUnit(), TimeUnit.SECONDS);
        newMeter.mark(unitCount);
        return newMeter;
    }

    public PinotMeter getMeteredTableValue(String tableName, M meter) {
        String meterName = meter.getMeterName();
        String fullMeterName = this._metricPrefix + this.getTableName(tableName) + "." + meterName;
        PinotMetricName metricName = PinotMetricUtils.makePinotMetricName(this._clazz, fullMeterName);
        return PinotMetricUtils.makePinotMeter(this._metricsRegistry, metricName, meter.getUnit(), TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValueToTableGauge(String tableName, G gauge, long unitCount) {
        String gaugeName = gauge.getGaugeName();
        final String fullGaugeName = gaugeName + "." + this.getTableName(tableName);
        if (!this._gaugeValues.containsKey(fullGaugeName)) {
            Map<String, AtomicLong> map = this._gaugeValues;
            synchronized (map) {
                if (!this._gaugeValues.containsKey(fullGaugeName)) {
                    this._gaugeValues.put(fullGaugeName, new AtomicLong(unitCount));
                    this.addCallbackGauge(fullGaugeName, new Callable<Long>(){

                        @Override
                        public Long call() throws Exception {
                            return ((AtomicLong)AbstractMetrics.this._gaugeValues.get(fullGaugeName)).get();
                        }
                    });
                } else {
                    this._gaugeValues.get(fullGaugeName).addAndGet(unitCount);
                }
            }
        } else {
            this._gaugeValues.get(fullGaugeName).addAndGet(unitCount);
        }
    }

    public void setValueOfTableGauge(String tableName, G gauge, long value) {
        String gaugeName = gauge.getGaugeName();
        String fullGaugeName = gaugeName + "." + this.getTableName(tableName);
        this.setValueOfGauge(value, fullGaugeName);
    }

    public void setValueOfPartitionGauge(String tableName, int partitionId, G gauge, long value) {
        String gaugeName = gauge.getGaugeName();
        String fullGaugeName = gaugeName + "." + this.getTableName(tableName) + "." + partitionId;
        this.setValueOfGauge(value, fullGaugeName);
    }

    public void setValueOfGlobalGauge(G gauge, String suffix, long value) {
        String gaugeName = gauge.getGaugeName();
        String fullGaugeName = gaugeName + "." + suffix;
        this.setValueOfGauge(value, fullGaugeName);
    }

    public void setValueOfGlobalGauge(G gauge, long value) {
        String gaugeName = gauge.getGaugeName();
        this.setValueOfGauge(value, gaugeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValueOfGauge(long value, String gaugeName) {
        if (!this._gaugeValues.containsKey(gaugeName)) {
            Map<String, AtomicLong> map = this._gaugeValues;
            synchronized (map) {
                if (!this._gaugeValues.containsKey(gaugeName)) {
                    this._gaugeValues.put(gaugeName, new AtomicLong(value));
                    this.addCallbackGauge(gaugeName, () -> this._gaugeValues.get(gaugeName).get());
                } else {
                    this._gaugeValues.get(gaugeName).set(value);
                }
            }
        } else {
            this._gaugeValues.get(gaugeName).set(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValueToGlobalGauge(G gauge, long unitCount) {
        final String gaugeName = gauge.getGaugeName();
        if (!this._gaugeValues.containsKey(gaugeName)) {
            Map<String, AtomicLong> map = this._gaugeValues;
            synchronized (map) {
                if (!this._gaugeValues.containsKey(gaugeName)) {
                    this._gaugeValues.put(gaugeName, new AtomicLong(unitCount));
                    this.addCallbackGauge(gaugeName, new Callable<Long>(){

                        @Override
                        public Long call() throws Exception {
                            return ((AtomicLong)AbstractMetrics.this._gaugeValues.get(gaugeName)).get();
                        }
                    });
                } else {
                    this._gaugeValues.get(gaugeName).addAndGet(unitCount);
                }
            }
        } else {
            this._gaugeValues.get(gaugeName).addAndGet(unitCount);
        }
    }

    @VisibleForTesting
    public long getValueOfGlobalGauge(G gauge) {
        String gaugeName = gauge.getGaugeName();
        if (!this._gaugeValues.containsKey(gaugeName)) {
            return 0L;
        }
        return this._gaugeValues.get(gaugeName).get();
    }

    @VisibleForTesting
    public long getValueOfGlobalGauge(G gauge, String suffix) {
        String fullGaugeName = gauge.getGaugeName() + "." + suffix;
        if (!this._gaugeValues.containsKey(fullGaugeName)) {
            return 0L;
        }
        return this._gaugeValues.get(fullGaugeName).get();
    }

    public long getValueOfTableGauge(String tableName, G gauge) {
        String gaugeName = gauge.getGaugeName();
        String fullGaugeName = gaugeName + "." + this.getTableName(tableName);
        if (!this._gaugeValues.containsKey(fullGaugeName)) {
            return 0L;
        }
        return this._gaugeValues.get(fullGaugeName).get();
    }

    public void initializeGlobalMeters() {
        Meter[] meters = this.getMeters();
        LOGGER.info("Initializing global {} meters", (Object)meters.length);
        for (Meter meter : meters) {
            if (!meter.isGlobal()) continue;
            this.addMeteredGlobalValue(meter, 0L);
        }
        Gauge[] gauges = this.getGauges();
        LOGGER.info("Initializing global {} gauges", (Object)gauges.length);
        for (Gauge gauge : gauges) {
            if (!gauge.isGlobal()) continue;
            this.setValueOfGlobalGauge(gauge, 0L);
        }
    }

    public void addCallbackTableGaugeIfNeeded(String tableName, G gauge, Callable<Long> valueCallback) {
        String gaugeName = gauge.getGaugeName();
        String fullGaugeName = gaugeName + "." + this.getTableName(tableName);
        this.addCallbackGaugeIfNeeded(fullGaugeName, valueCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallbackGaugeIfNeeded(String metricName, Callable<Long> valueCallback) {
        if (!this._gaugeValues.containsKey(metricName)) {
            Map<String, AtomicLong> map = this._gaugeValues;
            synchronized (map) {
                if (!this._gaugeValues.containsKey(metricName)) {
                    this._gaugeValues.put(metricName, new AtomicLong(0L));
                    this.addCallbackGauge(metricName, valueCallback);
                }
            }
        }
    }

    public void addCallbackGauge(String metricName, Callable<Long> valueCallback) {
        PinotMetricUtils.makeGauge(this._metricsRegistry, PinotMetricUtils.makePinotMetricName(this._clazz, this._metricPrefix + metricName), PinotMetricUtils.makePinotGauge(avoid -> {
            try {
                return (Long)valueCallback.call();
            }
            catch (Exception e) {
                LOGGER.error("Caught exception", (Throwable)e);
                Utils.rethrowException(e);
                throw new AssertionError((Object)"Should not reach this");
            }
        }));
    }

    public void removeTableGauge(String tableName, G gauge) {
        String gaugeName = gauge.getGaugeName();
        String fullGaugeName = gaugeName + "." + this.getTableName(tableName);
        this.removeGauge(fullGaugeName);
    }

    public void removeGauge(String gaugeName) {
        if (this._gaugeValues.remove(gaugeName) != null) {
            this.removeCallbackGauge(gaugeName);
        }
    }

    private void removeCallbackGauge(String metricName) {
        PinotMetricUtils.removeMetric(this._metricsRegistry, PinotMetricUtils.makePinotMetricName(this._clazz, this._metricPrefix + metricName));
    }

    protected abstract QP[] getQueryPhases();

    protected abstract M[] getMeters();

    protected abstract G[] getGauges();

    protected String getTableName(String tableName) {
        return this._isTableLevelMetricsEnabled || this._allowedTables.contains(tableName) ? tableName : "allTables";
    }

    @VisibleForTesting
    public boolean containsGauge(String metricName) {
        return this._gaugeValues.containsKey(metricName);
    }

    public static interface Timer {
        public String getTimerName();

        public boolean isGlobal();
    }

    public static interface Gauge {
        public String getGaugeName();

        public String getUnit();

        public boolean isGlobal();
    }

    public static interface Meter {
        public String getMeterName();

        public String getUnit();

        public boolean isGlobal();
    }

    public static interface QueryPhase {
        public String getQueryPhaseName();
    }
}

