/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.messages;

import java.util.UUID;
import org.apache.helix.ZNRecord;
import org.apache.helix.model.Message;

public class SegmentRefreshMessage
extends Message {
    public static final String REFRESH_SEGMENT_MSG_SUB_TYPE = "REFRESH_SEGMENT";
    private static final String TABLE_NAME_KEY = "tableName";
    private static final String SEGMENT_NAME_KEY = "segmentName";

    public SegmentRefreshMessage(String tableNameWithType, String segmentName) {
        super(Message.MessageType.USER_DEFINE_MSG, UUID.randomUUID().toString());
        this.setMsgSubType(REFRESH_SEGMENT_MSG_SUB_TYPE);
        this.setExecutionTimeout(-1);
        ZNRecord znRecord = this.getRecord();
        znRecord.setSimpleField(TABLE_NAME_KEY, tableNameWithType);
        znRecord.setSimpleField(SEGMENT_NAME_KEY, segmentName);
    }

    public SegmentRefreshMessage(Message message) {
        super(message.getRecord());
        if (!message.getMsgSubType().equals(REFRESH_SEGMENT_MSG_SUB_TYPE)) {
            throw new IllegalArgumentException("Invalid message subtype:" + message.getMsgSubType());
        }
    }

    public String getTableNameWithType() {
        return this.getRecord().getSimpleField(TABLE_NAME_KEY);
    }

    public String getSegmentName() {
        return this.getRecord().getSimpleField(SEGMENT_NAME_KEY);
    }
}

