/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.http;

import java.util.List;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiGetRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiGetRequest.class);
    private final Executor _executor;
    private final HttpConnectionManager _connectionManager;

    public MultiGetRequest(Executor executor, HttpConnectionManager connectionManager) {
        this._executor = executor;
        this._connectionManager = connectionManager;
    }

    public CompletionService<GetMethod> execute(List<String> urls, int timeoutMs) {
        HttpClientParams clientParams = new HttpClientParams();
        clientParams.setConnectionManagerTimeout((long)timeoutMs);
        HttpClient client = new HttpClient(clientParams, this._connectionManager);
        ExecutorCompletionService<GetMethod> completionService = new ExecutorCompletionService<GetMethod>(this._executor);
        for (String url : urls) {
            completionService.submit(() -> {
                try {
                    GetMethod getMethod = new GetMethod(url);
                    getMethod.getParams().setSoTimeout(timeoutMs);
                    client.executeMethod((HttpMethod)getMethod);
                    return getMethod;
                }
                catch (Exception e) {
                    LOGGER.warn("Caught '{}' while executing GET on URL: {}", (Object)e.toString(), (Object)url);
                    throw e;
                }
            });
        }
        return completionService;
    }
}

