/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process;

import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.ContextHelper;

public class PageTreeValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext context) throws ValidationException {
        PDDocumentCatalog catalog = context.getDocument().getDocumentCatalog();
        if (catalog != null) {
            COSDictionary catalogDict = catalog.getCOSObject();
            if (!(catalogDict.getDictionaryObject(COSName.PAGES) instanceof COSDictionary)) {
                this.addValidationError(context, new ValidationResult.ValidationError("8.1", "/Pages dictionary entry is missing in document catalog"));
                return;
            }
            int p = 0;
            for (PDPage page : context.getDocument().getPages()) {
                context.setCurrentPageNumber(p);
                this.validatePage(context, page);
                if (context.getDocument().getValidationErrors().size() > context.getConfig().getMaxErrors()) {
                    context.addValidationError(new ValidationResult.ValidationError("-1", "Over " + context.getConfig().getMaxErrors() + " errors, page tree validation process aborted"));
                    break;
                }
                context.setCurrentPageNumber(null);
                ++p;
            }
        } else {
            context.addValidationError(new ValidationResult.ValidationError("1.2.14", "There are no Catalog entry in the Document"));
        }
    }

    private void validatePage(PreflightContext context, PDPage page) throws ValidationException {
        ContextHelper.validateElement(context, page, "page-process");
    }
}

