/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.parser;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdfparser.XrefTrailerResolver;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.preflight.Format;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.SyntaxValidationException;

public class PreflightParser
extends PDFParser {
    private static final Charset ENCODING = StandardCharsets.ISO_8859_1;
    private Format format = null;
    private PreflightConfiguration config = null;
    private PreflightDocument preflightDocument;
    private ValidationResult validationResult;

    public PreflightParser(File file) throws IOException {
        super((RandomAccessRead)new RandomAccessReadBufferedFile(file));
    }

    public PreflightParser(String filename) throws IOException {
        this(new File(filename));
    }

    private void addValidationError(ValidationResult.ValidationError error) {
        this.validationResult.addError(error);
    }

    public PDDocument parse() throws IOException {
        return this.parse(Format.PDF_A1B);
    }

    public PDDocument parse(Format format) throws IOException {
        return this.parse(format, null);
    }

    public PDDocument parse(Format format, PreflightConfiguration config) throws IOException {
        this.format = format == null ? Format.PDF_A1B : format;
        this.config = config;
        this.validationResult = new ValidationResult(true);
        PDDocument pdDocument = null;
        this.checkPdfHeader();
        try {
            pdDocument = super.parse(false);
        }
        catch (IOException e) {
            this.addValidationError(new ValidationResult.ValidationError("1.0", e.getMessage()));
            throw new SyntaxValidationException(e, this.validationResult);
        }
        PreflightContext context = new PreflightContext();
        context.setDocument(this.preflightDocument);
        this.preflightDocument.setContext(context);
        context.setXrefTrailerResolver(this.xrefTrailerResolver);
        context.setFileLen(this.fileLen);
        this.preflightDocument.addValidationErrors(this.validationResult.getErrorsList());
        return pdDocument;
    }

    protected PDDocument createDocument() throws IOException {
        this.preflightDocument = new PreflightDocument(this.document, this.format, this.config);
        return this.preflightDocument;
    }

    protected void initialParse() throws IOException {
        super.initialParse();
        Set objectKeys = this.document.getXrefTable().keySet();
        objectKeys.forEach(key -> this.document.getObjectFromPool(key).getObject());
    }

    protected boolean resetTrailerResolver() {
        return false;
    }

    private void checkPdfHeader() {
        try {
            String secondLine;
            this.source.seek(0L);
            String firstLine = this.readLine();
            if (firstLine == null || !firstLine.matches("%PDF-1\\.[1-9]")) {
                this.addValidationError(new ValidationResult.ValidationError("1.1", "First line must match %PDF-1.\\d"));
            }
            if ((secondLine = this.readLine()) != null) {
                boolean secondLineFails = false;
                byte[] secondLineAsBytes = secondLine.getBytes(ENCODING);
                if (secondLineAsBytes.length == 0 || secondLineAsBytes[0] != 37) {
                    secondLineFails = true;
                } else if (secondLine.length() >= 5) {
                    for (int i = 1; i < 5; ++i) {
                        secondLineFails |= (secondLineAsBytes[i] & 0xFF) < 128;
                    }
                }
                if (secondLineFails) {
                    this.addValidationError(new ValidationResult.ValidationError("1.1", "Second line must begin with '%' followed by at least 4 bytes greater than 127"));
                }
            }
            this.source.seek(0L);
        }
        catch (IOException e) {
            this.addValidationError(new ValidationResult.ValidationError("1.1", "Unable to read the PDF file : " + e.getMessage(), e));
        }
    }

    protected boolean parseXrefTable(long startByteOffset) throws IOException {
        if (this.source.peek() != 120) {
            return false;
        }
        String xref = this.readString();
        if (!xref.equals("xref")) {
            this.addValidationError(new ValidationResult.ValidationError("1.3", "xref must be followed by a EOL character"));
            return false;
        }
        if (!this.nextIsEOL()) {
            this.addValidationError(new ValidationResult.ValidationError("1.3", "xref must be followed by EOL"));
        }
        this.xrefTrailerResolver.nextXrefObj(startByteOffset, XrefTrailerResolver.XRefType.TABLE);
        Pattern pattern = Pattern.compile("(\\d+)\\s(\\d+)(\\s*)");
        do {
            int count;
            long currObjID;
            long offset = this.source.getPosition();
            String line = this.readLine();
            Matcher matcher = pattern.matcher(line);
            if (matcher.matches()) {
                currObjID = Long.parseLong(matcher.group(1));
                count = Integer.parseInt(matcher.group(2));
            } else {
                this.addValidationError(new ValidationResult.ValidationError("1.3", "Cross reference subsection header is invalid: '" + line + "' at position " + this.source.getPosition()));
                this.source.seek(offset);
                currObjID = this.readObjectNumber();
                count = this.readInt();
            }
            this.skipSpaces();
            for (int i = 0; i < count && !this.source.isEOF() && !this.isEndOfName((char)this.source.peek()); ++i) {
                if (this.source.peek() == 116) {
                    this.addValidationError(new ValidationResult.ValidationError("1.3", "Expected xref line but 't' found"));
                    break;
                }
                String currentLine = this.readLine();
                String[] splitString = currentLine.split(" ");
                if (splitString.length < 3) {
                    this.addValidationError(new ValidationResult.ValidationError("1.3", "invalid xref line: " + currentLine));
                    break;
                }
                if (splitString[splitString.length - 1].equals("n")) {
                    try {
                        long currOffset = Long.parseLong(splitString[0]);
                        int currGenID = Integer.parseInt(splitString[1]);
                        COSObjectKey objKey = new COSObjectKey(currObjID, currGenID);
                        this.xrefTrailerResolver.setXRef(objKey, currOffset);
                    }
                    catch (NumberFormatException e) {
                        this.addValidationError(new ValidationResult.ValidationError("1.3", "offset or genid can't be read as number " + e.getMessage(), e));
                    }
                } else if (!splitString[2].equals("f")) {
                    this.addValidationError(new ValidationResult.ValidationError("1.3", "Corrupt XRefTable Entry - ObjID:" + currObjID));
                }
                ++currObjID;
                this.skipSpaces();
            }
            this.skipSpaces();
        } while (this.isDigit());
        return true;
    }

    protected COSStream parseCOSStream(COSDictionary dic) throws IOException {
        long startOffset = this.checkStreamKeyWord();
        COSStream result = super.parseCOSStream(dic);
        this.checkEndstreamKeyWord(dic, startOffset);
        return result;
    }

    private long checkStreamKeyWord() throws IOException {
        String streamV = this.readString();
        if (!streamV.equals("stream")) {
            this.addValidationError(new ValidationResult.ValidationError("1.2.2", "Expected 'stream' keyword but found '" + streamV + "' at offset " + this.source.getPosition()));
        }
        long startOffset = this.source.getPosition();
        int nextChar = this.source.read();
        if (nextChar == 13 && this.source.peek() == 10) {
            startOffset += 2L;
        } else if (nextChar == 10) {
            ++startOffset;
        } else {
            this.addValidationError(new ValidationResult.ValidationError("1.2.2", "Expected 'EOL' after the stream keyword at offset " + this.source.getPosition()));
        }
        this.source.seek(this.source.getPosition() - 7L);
        return startOffset;
    }

    private void checkEndstreamKeyWord(COSDictionary dic, long startOffset) throws IOException {
        String endstreamV;
        this.source.seek(this.source.getPosition() - 10L);
        long endOffset = this.source.getPosition();
        int nextChar = this.source.read();
        boolean eolFound = false;
        boolean crlfFound = false;
        if (nextChar == 10) {
            eolFound = true;
            this.source.rewind(2);
            if (this.source.read() == 13) {
                --endOffset;
                crlfFound = true;
            }
            this.source.read();
        }
        boolean addStreamLengthErrorMessage = false;
        long actualLength = endOffset - startOffset;
        if (!eolFound) {
            this.addValidationError(new ValidationResult.ValidationError("1.2.2", "Expected 'EOL' before the endstream keyword at offset " + this.source.getPosition() + " but found '" + this.source.peek() + "'"));
            addStreamLengthErrorMessage = true;
        }
        if (!(endstreamV = this.readString()).equals("endstream")) {
            this.addValidationError(new ValidationResult.ValidationError("1.2.2", "Expected 'endstream' keyword at offset " + this.source.getPosition() + " but found '" + endstreamV + "'"));
            addStreamLengthErrorMessage = true;
        }
        int length = dic.getInt(COSName.LENGTH);
        if (addStreamLengthErrorMessage || length > -1 && (!crlfFound && (long)length - actualLength != 0L || crlfFound && (long)length - actualLength > 1L)) {
            this.addValidationError(new ValidationResult.ValidationError("1.2.5", "Stream length is invalid [dic=" + dic + "; defined length=" + length + "; actual length=" + actualLength + ", starting offset=" + startOffset));
        }
    }

    private boolean nextIsEOL() throws IOException {
        boolean succeed = false;
        int nextChar = this.source.read();
        if (13 == nextChar && 10 == this.source.peek()) {
            this.source.read();
            succeed = true;
        } else if (13 == nextChar || 10 == nextChar) {
            succeed = true;
        }
        return succeed;
    }

    protected COSArray parseCOSArray() throws IOException {
        COSArray result = super.parseCOSArray();
        if (result != null && result.size() > 8191) {
            this.addValidationError(new ValidationResult.ValidationError("1.0.2", "Array too long : " + result.size()));
        }
        return result;
    }

    protected COSName parseCOSName() throws IOException {
        COSName result = super.parseCOSName();
        if (result != null && result.getName().getBytes().length > 127) {
            this.addValidationError(new ValidationResult.ValidationError("1.0.3", "Name too long: " + result.getName()));
        }
        return result;
    }

    protected COSString parseCOSString() throws IOException {
        long offset = this.source.getPosition();
        char nextChar = (char)this.source.read();
        int count = 0;
        if (nextChar == '<') {
            do {
                if (PreflightParser.isWhitespace((int)(nextChar = (char)this.source.read())) || nextChar == '>') continue;
                if (Character.digit(nextChar, 16) >= 0) {
                    ++count;
                    continue;
                }
                this.addValidationError(new ValidationResult.ValidationError("1.0.12", "Hexa String must have only Hexadecimal Characters (found '" + nextChar + "') at offset " + this.source.getPosition()));
                break;
            } while (nextChar != '>');
        }
        if (count % 2 != 0) {
            this.addValidationError(new ValidationResult.ValidationError("1.0.11", "Hexa string shall contain even number of non white space char at offset " + this.source.getPosition()));
        }
        this.source.seek(offset);
        COSString result = super.parseCOSString();
        if (result.getString().length() > 65535) {
            this.addValidationError(new ValidationResult.ValidationError("1.0.5", "Hexa string is too long at offset " + this.source.getPosition()));
        }
        return result;
    }

    protected COSBase parseDirObject() throws IOException {
        COSDictionary dic;
        COSBase result = super.parseDirObject();
        if (result instanceof COSNumber) {
            COSNumber number = (COSNumber)result;
            if (number instanceof COSFloat) {
                float real = number.floatValue();
                if (real > 32767.0f || real < -32767.0f) {
                    this.addValidationError(new ValidationResult.ValidationError("1.0.6", "Float is too long or too small: " + real + "  at offset " + this.source.getPosition()));
                }
            } else {
                long numAsLong = number.longValue();
                if (numAsLong > Integer.MAX_VALUE || numAsLong < Integer.MIN_VALUE) {
                    this.addValidationError(new ValidationResult.ValidationError("1.0.6", "Numeric is too long or too small: " + numAsLong + "  at offset " + this.source.getPosition()));
                }
            }
        }
        if (result instanceof COSDictionary && (dic = (COSDictionary)result).size() > 4095) {
            this.addValidationError(new ValidationResult.ValidationError("1.0.1", "Too Many Entries In Dictionary at offset " + this.source.getPosition()));
        }
        return result;
    }

    protected synchronized COSBase parseObjectDynamically(COSObjectKey objKey, boolean requireExistingNotCompressedObj) throws IOException {
        COSObject pdfObject = this.document.getObjectFromPool(objKey);
        if (!pdfObject.isObjectNull()) {
            return pdfObject.getObject();
        }
        COSBase referencedObject = null;
        Long offsetOrObjstmObNr = (Long)this.document.getXrefTable().get(objKey);
        if (requireExistingNotCompressedObj && offsetOrObjstmObNr == null) {
            this.addValidationError(new ValidationResult.ValidationError("1.0.13", "Object must be defined and must not be compressed object: " + objKey.getNumber() + ":" + objKey.getGeneration()));
            throw new SyntaxValidationException("Object must be defined and must not be compressed object: " + objKey.getNumber() + ":" + objKey.getGeneration(), this.validationResult);
        }
        if (offsetOrObjstmObNr != null) {
            if (offsetOrObjstmObNr == 0L) {
                this.addValidationError(new ValidationResult.ValidationError("1.0.14", "Object {" + objKey.getNumber() + ":" + objKey.getGeneration() + "} has an offset of 0"));
            } else {
                referencedObject = offsetOrObjstmObNr > 0L ? this.parseFileObject(offsetOrObjstmObNr, objKey) : this.parseObjectStreamObject(-offsetOrObjstmObNr.longValue(), objKey);
            }
        }
        if (referencedObject == null || referencedObject instanceof COSNull) {
            pdfObject.setToNull();
        }
        return referencedObject;
    }

    private COSBase parseFileObject(Long offsetOrObjstmObNr, COSObjectKey objKey) throws IOException {
        int readObjGen;
        long readObjNr;
        this.source.seek(offsetOrObjstmObNr.longValue());
        long offset = this.source.getPosition();
        String line = this.readLine();
        Pattern pattern = Pattern.compile("(\\d+)\\s(\\d+)\\sobj");
        Matcher matcher = pattern.matcher(line);
        if (matcher.matches()) {
            readObjNr = Long.parseLong(matcher.group(1));
            readObjGen = Integer.parseInt(matcher.group(2));
        } else {
            this.addValidationError(new ValidationResult.ValidationError("1.2.1", "Single space expected [offset=" + offset + "; key=" + offsetOrObjstmObNr.toString() + "; line=" + line + "; object=" + objKey.getNumber() + " " + objKey.getGeneration() + "]"));
            this.source.seek(offset);
            readObjNr = this.readObjectNumber();
            readObjGen = this.readGenerationNumber();
            this.skipSpaces();
            for (char c : OBJ_MARKER) {
                if (this.source.read() == c) continue;
                this.addValidationError(new ValidationResult.ValidationError("1.2.1", "Expected pattern '" + new String(OBJ_MARKER) + " but missed at character '" + c + "'"));
                throw new SyntaxValidationException("Expected pattern '" + new String(OBJ_MARKER) + " but missed at character '" + c + "'", this.validationResult);
            }
        }
        if (readObjNr != objKey.getNumber() || readObjGen != objKey.getGeneration()) {
            throw new IOException("XREF for " + objKey.getNumber() + ":" + objKey.getGeneration() + " points to wrong object: " + readObjNr + ":" + readObjGen);
        }
        this.skipSpaces();
        COSBase referencedObject = this.parseDirObject();
        this.skipSpaces();
        long endObjectOffset = this.source.getPosition();
        String endObjectKey = this.readString();
        if (endObjectKey.equals("stream")) {
            COSStream stream;
            this.source.seek(endObjectOffset);
            if (referencedObject instanceof COSDictionary) {
                stream = this.parseCOSStream((COSDictionary)referencedObject);
                if (this.securityHandler != null) {
                    this.securityHandler.decryptStream(stream, readObjNr, (long)readObjGen);
                }
            } else {
                throw new IOException("Stream not preceded by dictionary (offset: " + offsetOrObjstmObNr + ").");
            }
            referencedObject = stream;
            this.skipSpaces();
            endObjectOffset = this.source.getPosition();
            endObjectKey = this.readString();
            if (!endObjectKey.startsWith("endobj") && endObjectKey.startsWith("endstream") && (endObjectKey = endObjectKey.substring(9).trim()).length() == 0) {
                endObjectKey = this.readString();
            }
        } else if (this.securityHandler != null) {
            this.securityHandler.decrypt(referencedObject, readObjNr, (long)readObjGen);
        }
        if (!endObjectKey.startsWith("endobj")) {
            throw new IOException("Object (" + readObjNr + ":" + readObjGen + ") at offset " + offsetOrObjstmObNr + " does not end with 'endobj'.");
        }
        offset = this.source.getPosition();
        this.source.seek(endObjectOffset - 1L);
        if (!this.nextIsEOL()) {
            this.addValidationError(new ValidationResult.ValidationError("1.2.1", "EOL expected before the 'endobj' keyword at offset " + this.source.getPosition()));
        }
        this.source.seek(offset);
        if (!this.nextIsEOL()) {
            this.addValidationError(new ValidationResult.ValidationError("1.2.1", "EOL expected after the 'endobj' keyword at offset " + this.source.getPosition()));
        }
        return referencedObject;
    }

    protected int lastIndexOf(char[] pattern, byte[] buf, int endOff) {
        int tmpOffset;
        int offsetDiff;
        int offset = super.lastIndexOf(pattern, buf, endOff);
        if (offset > 0 && Arrays.equals(pattern, EOF_MARKER) && ((offsetDiff = buf.length - (tmpOffset = offset + pattern.length)) > 2 || offsetDiff == 2 && (buf[tmpOffset] != 13 || buf[tmpOffset + 1] != 10) || offsetDiff == 1 && buf[tmpOffset] != 13 && buf[tmpOffset] != 10)) {
            long position;
            try {
                position = this.source.getPosition();
            }
            catch (IOException ex) {
                position = Long.MIN_VALUE;
            }
            this.addValidationError(new ValidationResult.ValidationError("1.4.10", "File contains data after the last %%EOF sequence at offset " + position));
        }
        return offset;
    }

    public static ValidationResult validate(File file) throws IOException {
        ValidationResult result;
        PreflightParser parser = new PreflightParser(file);
        try (PreflightDocument document = (PreflightDocument)parser.parse();){
            result = document.validate();
        }
        catch (SyntaxValidationException e) {
            result = e.getResult();
        }
        return result;
    }
}

