/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.cmap.CMapParser;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType0;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.font.CIDType0FontValidator;
import org.apache.pdfbox.preflight.font.CIDType2FontValidator;
import org.apache.pdfbox.preflight.font.FontValidator;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.apache.pdfbox.preflight.font.container.Type0Container;
import org.apache.pdfbox.preflight.utils.COSUtils;

public class Type0FontValidator
extends FontValidator<Type0Container> {
    protected PDFont font;
    protected COSDocument cosDocument = this.context.getDocument().getDocument();

    public Type0FontValidator(PreflightContext context, PDFont font) {
        super(context, font.getCOSObject(), new Type0Container(font));
        this.font = font;
    }

    @Override
    public void validate() throws ValidationException {
        this.checkMandatoryFields();
        this.processDescendantFont();
        this.checkEncoding();
        this.checkToUnicode();
    }

    protected void checkMandatoryFields() {
        COSDictionary fontDictionary = this.font.getCOSObject();
        boolean areFieldsPResent = fontDictionary.containsKey(COSName.TYPE);
        areFieldsPResent &= fontDictionary.containsKey(COSName.SUBTYPE);
        areFieldsPResent &= fontDictionary.containsKey(COSName.BASE_FONT);
        areFieldsPResent &= fontDictionary.containsKey(COSName.DESCENDANT_FONTS);
        if (!(areFieldsPResent &= fontDictionary.containsKey(COSName.ENCODING))) {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": Some keys are missing from composite font dictionary"));
        }
    }

    protected void processDescendantFont() throws ValidationException {
        COSDictionary fontDictionary = this.font.getCOSObject();
        COSArray array = COSUtils.getAsArray(fontDictionary.getItem(COSName.DESCENDANT_FONTS), this.cosDocument);
        if (array == null || array.size() != 1) {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.7", this.font.getName() + ": CIDFont is missing from the DescendantFonts array or the size of array is greater than 1"));
            return;
        }
        COSDictionary cidFont = COSUtils.getAsDictionary(array.get(0), this.cosDocument);
        if (cidFont == null) {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.7", this.font.getName() + ": The DescendantFonts array should have one element with is a dictionary."));
            return;
        }
        FontValidator<? extends FontContainer> cidFontValidator = this.createDescendantValidator(cidFont);
        if (cidFontValidator != null) {
            ((Type0Container)this.fontContainer).setDelegateFontContainer(cidFontValidator.getFontContainer());
            cidFontValidator.validate();
        }
    }

    protected FontValidator<? extends FontContainer> createDescendantValidator(COSDictionary cidFont) {
        String subtype = cidFont.getNameAsString(COSName.SUBTYPE);
        FontValidator<? extends FontContainer> cidFontValidator = null;
        if ("CIDFontType0".equals(subtype)) {
            cidFontValidator = this.createCIDType0FontValidator(cidFont);
        } else if ("CIDFontType2".equals(subtype)) {
            cidFontValidator = this.createCIDType2FontValidator(cidFont);
        } else {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", this.font.getName() + ": Type and/or Subtype keys are missing"));
        }
        return cidFontValidator;
    }

    protected FontValidator<? extends FontContainer> createCIDType0FontValidator(COSDictionary fDict) {
        try {
            return new CIDType0FontValidator(this.context, new PDCIDFontType0(fDict, (PDType0Font)this.font));
        }
        catch (IOException e) {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.3", this.font.getName() + ": The CIDType0 font is damaged", e));
            return null;
        }
    }

    protected FontValidator<? extends FontContainer> createCIDType2FontValidator(COSDictionary fDict) {
        try {
            return new CIDType2FontValidator(this.context, new PDCIDFontType2(fDict, (PDType0Font)this.font));
        }
        catch (IOException e) {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.3", this.font.getName() + ": The CIDType2 font is damaged", e));
            return null;
        }
    }

    @Override
    protected void checkEncoding() {
        COSBase encoding = this.font.getCOSObject().getItem(COSName.ENCODING);
        this.checkCMapEncoding(encoding);
    }

    protected void checkCMapEncoding(COSBase encoding) {
        if (COSUtils.isString(encoding, this.cosDocument)) {
            String str = COSUtils.getAsString(encoding, this.cosDocument);
            if (!"Identity-V".equals(str) && !"Identity-H".equals(str)) {
                ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.7", this.font.getName() + ": The CMap is a string but it isn't an Identity-H/V"));
                return;
            }
        } else if (COSUtils.isStream(encoding, this.cosDocument)) {
            this.processCMapAsStream(COSUtils.getAsStream(encoding, this.cosDocument));
        } else {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.10", this.font.getName() + ": The CMap type is invalid"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCMapAsStream(COSStream aCMap) {
        COSBase sysinfo = aCMap.getItem(COSName.CIDSYSTEMINFO);
        this.checkCIDSystemInfo(sysinfo);
        COSInputStream cmapStream = null;
        try {
            cmapStream = aCMap.createInputStream();
            CMap fontboxCMap = new CMapParser().parse((InputStream)cmapStream);
            int wmValue = fontboxCMap.getWMode();
            String cmnValue = fontboxCMap.getName();
            int wmode = aCMap.getInt(COSName.getPDFName((String)"WMode"), 0);
            String type = aCMap.getNameAsString(COSName.TYPE);
            String cmapName = aCMap.getNameAsString(COSName.getPDFName((String)"CMapName"));
            if (cmapName == null || "".equals(cmapName) || wmode > 1) {
                ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.10", this.font.getName() + ": Some elements in the CMap dictionary are missing or invalid"));
            } else if (wmValue != wmode || !cmapName.equals(cmnValue)) {
                ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.10", this.font.getName() + ": CMapName or WMode is inconsistent"));
            } else if (!"CMap".equals(type)) {
                ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.10", this.font.getName() + ": The CMap type is invalid"));
            }
        }
        catch (IOException e) {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.5", this.font.getName() + ": The CMap type is damaged", e));
        }
        finally {
            IOUtils.closeQuietly((InputStream)cmapStream);
        }
        COSDictionary cmapUsed = (COSDictionary)aCMap.getDictionaryObject(COSName.getPDFName((String)"UseCMap"));
        if (cmapUsed != null) {
            this.checkCMapEncoding((COSBase)cmapUsed);
        }
        this.compareCIDSystemInfo((COSDictionary)aCMap);
    }

    protected boolean checkCIDSystemInfo(COSBase sysinfo) {
        boolean result = true;
        COSDictionary cidSysInfo = COSUtils.getAsDictionary(sysinfo, this.cosDocument);
        if (cidSysInfo != null) {
            COSBase reg = cidSysInfo.getItem(COSName.REGISTRY);
            COSBase ord = cidSysInfo.getItem(COSName.ORDERING);
            COSBase sup = cidSysInfo.getItem(COSName.SUPPLEMENT);
            if (!(COSUtils.isString(reg, this.cosDocument) && COSUtils.isString(ord, this.cosDocument) && COSUtils.isInteger(sup, this.cosDocument))) {
                ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.8"));
                result = false;
            }
        } else {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.8"));
            result = false;
        }
        return result;
    }

    private void compareCIDSystemInfo(COSDictionary cmap) {
        COSDictionary fontDictionary = this.font.getCOSObject();
        COSArray array = COSUtils.getAsArray(fontDictionary.getItem(COSName.DESCENDANT_FONTS), this.cosDocument);
        if (array != null && array.size() > 0) {
            COSDictionary cidFont = COSUtils.getAsDictionary(array.get(0), this.cosDocument);
            COSDictionary cmsi = COSUtils.getAsDictionary(cmap.getItem(COSName.CIDSYSTEMINFO), this.cosDocument);
            COSDictionary cfsi = COSUtils.getAsDictionary(cidFont.getItem(COSName.CIDSYSTEMINFO), this.cosDocument);
            String regCM = COSUtils.getAsString(cmsi.getItem(COSName.REGISTRY), this.cosDocument);
            String ordCM = COSUtils.getAsString(cmsi.getItem(COSName.ORDERING), this.cosDocument);
            String regCF = COSUtils.getAsString(cfsi.getItem(COSName.REGISTRY), this.cosDocument);
            String ordCF = COSUtils.getAsString(cfsi.getItem(COSName.ORDERING), this.cosDocument);
            if (!regCF.equals(regCM) || !ordCF.equals(ordCM)) {
                ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.8", this.font.getName() + ": The CIDSystemInfo is inconsistent"));
            }
        }
    }
}

