/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.descriptor;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.fontbox.cff.CFFParser;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorDictionary;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.font.FontValidator;
import org.apache.pdfbox.preflight.font.container.Type1Container;
import org.apache.pdfbox.preflight.font.descriptor.FontDescriptorHelper;
import org.apache.pdfbox.preflight.font.util.Type1;
import org.apache.pdfbox.preflight.font.util.Type1Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type1DescriptorHelper
extends FontDescriptorHelper<Type1Container> {
    private boolean isFontFile1 = true;

    public Type1DescriptorHelper(PreflightContext context, PDFont font, Type1Container fontContainer) {
        super(context, font, fontContainer);
    }

    @Override
    protected boolean checkMandatoryFields(COSDictionary fDescriptor) {
        String charsetStr;
        boolean result = super.checkMandatoryFields(fDescriptor);
        if (FontValidator.isSubSet(this.fontDescriptor.getFontName()) && ((charsetStr = this.fontDescriptor.getCharSet()) == null || "".equals(charsetStr))) {
            ((Type1Container)this.fContainer).push(new ValidationResult.ValidationError("3.1.4", "The Charset entry is missing for the Type1 Subset"));
            result = false;
        }
        return result;
    }

    @Override
    public PDStream extractFontFile(PDFontDescriptorDictionary fontDescriptor) {
        PDStream ff1 = fontDescriptor.getFontFile();
        PDStream ff3 = fontDescriptor.getFontFile3();
        if (ff1 != null) {
            boolean hasLength3;
            COSStream stream = ff1.getStream();
            if (stream == null) {
                ((Type1Container)this.fContainer).push(new ValidationResult.ValidationError("3.1.3", "The FontFile is missing for " + fontDescriptor.getFontName()));
                ((Type1Container)this.fContainer).notEmbedded();
                return null;
            }
            boolean hasLength1 = stream.getInt(COSName.LENGTH1) > 0;
            boolean hasLength2 = stream.getInt(COSName.getPDFName((String)"Length2")) > 0;
            boolean bl = hasLength3 = stream.getInt(COSName.getPDFName((String)"Length3")) >= 0;
            if (!(hasLength1 && hasLength2 && hasLength3)) {
                ((Type1Container)this.fContainer).push(new ValidationResult.ValidationError("3.1.3", "The FontFile is invalid for " + fontDescriptor.getFontName()));
                return null;
            }
            return ff1;
        }
        this.isFontFile1 = false;
        ((Type1Container)this.fContainer).setFontFile1(this.isFontFile1);
        return ff3;
    }

    @Override
    protected void processFontFile(PDFontDescriptorDictionary fontDescriptor, PDStream fontFile) {
        if (this.isFontFile1) {
            this.processFontFile1(fontDescriptor, fontFile);
        } else {
            this.processFontFile3(fontDescriptor, fontFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void processFontFile1(PDFontDescriptorDictionary fontDescriptor, PDStream fontFile) {
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(fontFile.getByteArray());
            Font.createFont(1, bis);
            IOUtils.closeQuietly((InputStream)bis);
            COSStream streamObj = fontFile.getStream();
            int length1 = streamObj.getInt(COSName.LENGTH1);
            int length2 = streamObj.getInt(COSName.LENGTH2);
            bis = new ByteArrayInputStream(fontFile.getByteArray());
            Type1Parser parserForMetrics = Type1Parser.createParserWithEncodingObject(bis, length1, length2, this.font.getFontEncoding());
            Type1 parsedData = parserForMetrics.parse();
            ((Type1Container)this.fContainer).setType1Font(parsedData);
        }
        catch (IOException e) {
            ((Type1Container)this.fContainer).push(new ValidationResult.ValidationError("3.2.1", "The FontFile can't be read"));
            IOUtils.closeQuietly((InputStream)bis);
        }
        catch (FontFormatException e2) {
            ((Type1Container)this.fContainer).push(new ValidationResult.ValidationError("3.2.1", "The FontFile is damaged"));
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bis);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)bis);
        }
        IOUtils.closeQuietly((InputStream)bis);
    }

    protected void processFontFile3(PDFontDescriptorDictionary fontDescriptor, PDStream fontFile) {
        try {
            CFFParser cffParser = new CFFParser();
            List lCFonts = cffParser.parse(fontFile.getByteArray());
            if (lCFonts == null || lCFonts.isEmpty()) {
                ((Type1Container)this.fContainer).push(new ValidationResult.ValidationError("3.2.3", "The FontFile can't be read"));
            }
            ((Type1Container)this.fContainer).setCFFFontObjects(lCFonts);
        }
        catch (IOException e) {
            ((Type1Container)this.fContainer).push(new ValidationResult.ValidationError("3.2.3", "The FontFile can't be read"));
        }
    }
}

