/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process.reflect;

import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.xobject.XObjFormValidator;
import org.apache.pdfbox.preflight.xobject.XObjImageValidator;
import org.apache.pdfbox.preflight.xobject.XObjPostscriptValidator;

public class GraphicObjectPageValidationProcess
extends AbstractProcess {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(PreflightContext context) throws ValidationException {
        void var3_7;
        PreflightPath vPath = context.getValidationPath();
        Object var3_3 = null;
        if (!vPath.isEmpty() && vPath.isExpectedType(PDXObjectImage.class)) {
            XObjImageValidator xObjImageValidator = new XObjImageValidator(context, (PDXObjectImage)vPath.peek());
        } else if (!vPath.isEmpty() && vPath.isExpectedType(PDXObjectForm.class)) {
            XObjFormValidator xObjFormValidator = new XObjFormValidator(context, (PDXObjectForm)vPath.peek());
        } else {
            if (vPath.isEmpty() || !vPath.isExpectedType(COSStream.class)) throw new ValidationException("Graphic validation process needs at least one PDFont object");
            COSStream stream = (COSStream)vPath.peek();
            String subType = stream.getNameAsString(COSName.SUBTYPE);
            if (!"PS".equals(subType)) throw new ValidationException("Invalid XObject subtype");
            XObjPostscriptValidator xObjPostscriptValidator = new XObjPostscriptValidator(context, stream);
        }
        var3_7.validate();
    }
}

