/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight;

import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.pdfbox.Version;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.SyntaxValidationException;
import org.apache.pdfbox.preflight.parser.PreflightParser;

public class Validator_A1b {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage : java org.apache.pdfbox.preflight.Validator_A1b <file path>");
            System.out.println("Version : " + Version.getVersion());
            System.exit(1);
        }
        ValidationResult result = null;
        FileDataSource fd = new FileDataSource(args[0]);
        PreflightParser parser = new PreflightParser((DataSource)fd);
        try {
            parser.parse();
            PreflightDocument document = parser.getPreflightDocument();
            document.validate();
            result = document.getResult();
            document.close();
        }
        catch (SyntaxValidationException e) {
            result = e.getResult();
        }
        if (result.isValid()) {
            System.out.println("The file " + args[0] + " is a valid PDF/A-1b file");
            System.exit(0);
        } else {
            System.out.println("The file" + args[0] + " is not valid, error(s) :");
            for (ValidationResult.ValidationError error : result.getErrorsList()) {
                System.out.println(error.getErrorCode() + " : " + error.getDetails());
            }
            System.exit(-1);
        }
    }
}

