/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process.reflect;

import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPatternResources;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.content.ContentStreamWrapper;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.ContextHelper;

public class TilingPatternValidationProcess
extends AbstractProcess {
    public void validate(PreflightContext context) throws ValidationException {
        PreflightPath vPath = context.getValidationPath();
        if (vPath.isEmpty() && !vPath.isExpectedType(PDPage.class)) {
            throw new ValidationException("Tiling pattern validation required at least a PDPage");
        }
        PDTilingPatternResources tilingPattern = (PDTilingPatternResources)vPath.peek();
        PDPage page = vPath.getClosestPathElement(PDPage.class);
        this.checkMandatoryFields(context, page, tilingPattern);
        this.parseResources(context, page, tilingPattern);
        this.parsePatternContent(context, page, tilingPattern);
    }

    protected void parseResources(PreflightContext context, PDPage page, PDTilingPatternResources pattern) throws ValidationException {
        PDResources resources = pattern.getResources();
        if (resources != null) {
            ContextHelper.validateElement(context, resources, "resources-process");
        }
    }

    protected void parsePatternContent(PreflightContext context, PDPage page, PDTilingPatternResources pattern) throws ValidationException {
        ContentStreamWrapper csWrapper = new ContentStreamWrapper(context, page);
        csWrapper.validPatternContentStream((COSStream)pattern.getCOSObject());
    }

    protected void checkMandatoryFields(PreflightContext context, PDPage page, PDTilingPatternResources pattern) {
        COSDictionary dictionary = pattern.getCOSDictionary();
        boolean res = dictionary.getItem(COSName.RESOURCES) != null;
        res = res && dictionary.getItem(COSName.BBOX) != null;
        res = res && dictionary.getItem(COSName.PAINT_TYPE) != null;
        res = res && dictionary.getItem(COSName.TILING_TYPE) != null;
        res = res && dictionary.getItem(COSName.X_STEP) != null;
        boolean bl = res = res && dictionary.getItem(COSName.Y_STEP) != null;
        if (!res) {
            context.addValidationError(new ValidationResult.ValidationError("2.4.6"));
        }
    }
}

