/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process.reflect;

import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.COSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtGStateValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext context) throws ValidationException {
        PreflightPath vPath = context.getValidationPath();
        if (vPath.isEmpty() || !vPath.isExpectedType(COSDictionary.class)) {
            throw new ValidationException("ExtGState validation required at least a Resource dictionary");
        }
        COSDictionary extGStatesDict = (COSDictionary)vPath.peek();
        List<COSDictionary> listOfExtGState = this.extractExtGStateDictionaries(context, extGStatesDict);
        this.validateTransparencyRules(context, listOfExtGState);
    }

    public List<COSDictionary> extractExtGStateDictionaries(PreflightContext context, COSDictionary egsEntry) throws ValidationException {
        ArrayList<COSDictionary> listOfExtGState = new ArrayList<COSDictionary>(0);
        COSDocument cosDocument = context.getDocument().getDocument();
        COSDictionary extGStates = COSUtils.getAsDictionary((COSBase)egsEntry, cosDocument);
        if (extGStates != null) {
            for (Object object : extGStates.keySet()) {
                COSName key = (COSName)object;
                if (!key.getName().matches("(GS|gs)([0-9])+")) continue;
                COSBase gsBase = extGStates.getItem(key);
                COSDictionary gsDict = COSUtils.getAsDictionary(gsBase, cosDocument);
                if (gsDict == null) {
                    throw new ValidationException("The Extended Graphics State dictionary is invalid");
                }
                listOfExtGState.add(gsDict);
            }
        }
        return listOfExtGState;
    }

    protected void validateTransparencyRules(PreflightContext context, List<COSDictionary> listOfExtGState) {
        for (COSDictionary egs : listOfExtGState) {
            this.checkSoftMask(context, egs);
            this.checkCA(context, egs);
            this.checkBlendMode(context, egs);
            this.checkTRKey(context, egs);
            this.checkTR2Key(context, egs);
        }
    }

    private void checkSoftMask(PreflightContext context, COSDictionary egs) {
        COSBase smVal = egs.getItem(COSName.SMASK);
        if (!(smVal == null || smVal instanceof COSName && "None".equals(((COSName)smVal).getName()))) {
            context.addValidationError(new ValidationResult.ValidationError("4.1.1", "SoftMask must be null or None"));
        }
    }

    private void checkBlendMode(PreflightContext context, COSDictionary egs) {
        COSBase bmVal = egs.getItem("BM");
        if (!(bmVal == null || bmVal instanceof COSName && ("Normal".equals(((COSName)bmVal).getName()) || "Compatible".equals(((COSName)bmVal).getName())))) {
            context.addValidationError(new ValidationResult.ValidationError("4.1.3", "BlendMode value isn't valid (only Normal and Compatible are authorized)"));
        }
    }

    private void checkCA(PreflightContext context, COSDictionary egs) {
        Integer ica;
        Float fca;
        COSBase uCA = egs.getItem("CA");
        COSBase lCA = egs.getItem("ca");
        COSDocument cosDocument = context.getDocument().getDocument();
        if (uCA != null) {
            fca = COSUtils.getAsFloat(uCA, cosDocument);
            ica = COSUtils.getAsInteger(uCA, cosDocument);
            if (!(fca != null && fca.floatValue() == 1.0f || ica != null && ica == 1)) {
                context.addValidationError(new ValidationResult.ValidationError("4.1.2", "CA entry in a ExtGState is invalid"));
            }
        }
        if (lCA != null) {
            fca = COSUtils.getAsFloat(lCA, cosDocument);
            ica = COSUtils.getAsInteger(lCA, cosDocument);
            if (!(fca != null && fca.floatValue() == 1.0f || ica != null && ica == 1)) {
                context.addValidationError(new ValidationResult.ValidationError("4.1.2", "ca entry in a ExtGState  is invalid."));
            }
        }
    }

    protected void checkTRKey(PreflightContext context, COSDictionary egs) {
        if (egs.getItem("TR") != null) {
            context.addValidationError(new ValidationResult.ValidationError("2.3", "No TR key expected in Extended graphics state"));
        }
    }

    protected void checkTR2Key(PreflightContext context, COSDictionary egs) {
        String s;
        if (egs.getItem("TR2") != null && !"default".equals(s = egs.getNameAsString("TR2"))) {
            context.addValidationError(new ValidationResult.ValidationError("2.3.2", "TR2 key only expect 'default' value, not '" + s + "'"));
        }
    }
}

