/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process;

import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.interactive.action.PDFormFieldAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.ContextHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcroFormValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext ctx) throws ValidationException {
        PDDocumentCatalog catalog = ctx.getDocument().getDocumentCatalog();
        if (catalog != null) {
            PDAcroForm acroForm = catalog.getAcroForm();
            if (acroForm != null) {
                this.checkNeedAppearences(ctx, acroForm);
                try {
                    this.exploreFields(ctx, acroForm.getFields());
                }
                catch (IOException e) {
                    throw new ValidationException("Unable to get the list of fields : " + e.getMessage(), e);
                }
            }
        } else {
            throw new ValidationException("There are no Catalog entry in the Document.");
        }
    }

    protected void checkNeedAppearences(PreflightContext ctx, PDAcroForm acroForm) {
        if (acroForm.getDictionary().getBoolean("NeedAppearances", false)) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.2.3", "NeedAppearance is present with the value \"true\""));
        }
    }

    protected boolean exploreFields(PreflightContext ctx, List<?> lFields) throws IOException {
        if (lFields != null) {
            for (Object obj : lFields) {
                if (this.valideField(ctx, (PDField)obj)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean valideField(PreflightContext ctx, PDField aField) throws IOException {
        boolean res = true;
        PDFormFieldAdditionalActions aa = aField.getActions();
        if (aa != null) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("6.2.3", "\"AA\" must not be used in a Field dictionary"));
            res = false;
        }
        PDAnnotationWidget widget = aField.getWidget();
        if (res && widget != null) {
            ContextHelper.validateElement(ctx, widget.getDictionary(), "annotations-process");
            COSBase act = widget.getDictionary().getDictionaryObject(COSName.A);
            if (act != null) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("6.2.4", "\"A\" must not be used in a Field dictionary"));
                res = false;
            }
        }
        res = res && this.exploreFields(ctx, aField.getKids());
        return res;
    }
}

