/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools.imageio;

import java.io.StringWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MetaUtil {
    private static final Logger LOG = LogManager.getLogger(MetaUtil.class);
    static final String SUN_TIFF_FORMAT = "com_sun_media_imageio_plugins_tiff_image_1.0";
    static final String JPEG_NATIVE_FORMAT = "javax_imageio_jpeg_image_1.0";
    static final String STANDARD_METADATA_FORMAT = "javax_imageio_1.0";

    private MetaUtil() {
    }

    static void debugLogMetadata(IIOMetadata metadata, String format) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(format);
        try {
            StringWriter xmlStringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(xmlStringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource domSource = new DOMSource(root);
            transformer.transform(domSource, streamResult);
            LOG.debug("\n{}", (Object)xmlStringWriter);
        }
        catch (IllegalArgumentException | TransformerException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
    }
}

