/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools.imageio;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.tools.imageio.JPEGUtil;
import org.apache.pdfbox.tools.imageio.TIFFUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ImageIOUtil {
    private static final Logger LOG = LogManager.getLogger(ImageIOUtil.class);

    private ImageIOUtil() {
    }

    public static boolean writeImage(BufferedImage image, String filename, int dpi) throws IOException {
        float compressionQuality = 1.0f;
        String formatName = filename.substring(filename.lastIndexOf(46) + 1);
        if ("png".equalsIgnoreCase(formatName)) {
            compressionQuality = 0.0f;
        }
        return ImageIOUtil.writeImage(image, filename, dpi, compressionQuality);
    }

    public static boolean writeImage(BufferedImage image, String filename, int dpi, float compressionQuality) throws IOException {
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(filename));){
            String formatName = filename.substring(filename.lastIndexOf(46) + 1);
            boolean bl = ImageIOUtil.writeImage(image, formatName, output, dpi, compressionQuality);
            return bl;
        }
    }

    public static boolean writeImage(BufferedImage image, String formatName, OutputStream output) throws IOException {
        return ImageIOUtil.writeImage(image, formatName, output, 72);
    }

    public static boolean writeImage(BufferedImage image, String formatName, OutputStream output, int dpi) throws IOException {
        float compressionQuality = 1.0f;
        if ("png".equalsIgnoreCase(formatName)) {
            compressionQuality = 0.0f;
        }
        return ImageIOUtil.writeImage(image, formatName, output, dpi, compressionQuality);
    }

    public static boolean writeImage(BufferedImage image, String formatName, OutputStream output, int dpi, float compressionQuality) throws IOException {
        return ImageIOUtil.writeImage(image, formatName, output, dpi, compressionQuality, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeImage(BufferedImage image, String formatName, OutputStream output, int dpi, float compressionQuality, String compressionType) throws IOException {
        ImageInputStream imageOutput = null;
        ImageWriter writer = null;
        try {
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(formatName);
            ImageWriteParam param = null;
            IIOMetadata metadata = null;
            while (writers.hasNext()) {
                if (writer != null) {
                    writer.dispose();
                }
                if ((writer = writers.next()) == null || (metadata = writer.getDefaultImageMetadata(new ImageTypeSpecifier(image), param = writer.getDefaultWriteParam())) == null || metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
            }
            if (writer == null) {
                LOG.error("No ImageWriter found for '{}' format", (Object)formatName);
                LOG.error("Supported formats: {}", (Object)Arrays.toString(ImageIO.getWriterFormatNames()));
                boolean bl = false;
                return bl;
            }
            boolean isTifFormat = formatName.toLowerCase().startsWith("tif");
            if (param != null && param.canWriteCompressed()) {
                param.setCompressionMode(2);
                if (isTifFormat) {
                    if ("".equals(compressionType)) {
                        TIFFUtil.setCompressionType(param, image);
                    } else {
                        param.setCompressionType(compressionType);
                        if (compressionType != null) {
                            param.setCompressionQuality(compressionQuality);
                        }
                    }
                } else {
                    param.setCompressionType(param.getCompressionTypes()[0]);
                    param.setCompressionQuality(compressionQuality);
                }
            }
            if (metadata != null) {
                if (isTifFormat) {
                    TIFFUtil.updateMetadata(metadata, image, dpi);
                } else if ("jpeg".equalsIgnoreCase(formatName) || "jpg".equalsIgnoreCase(formatName)) {
                    JPEGUtil.updateMetadata(metadata, dpi);
                } else if (!metadata.isReadOnly() && metadata.isStandardMetadataFormatSupported()) {
                    ImageIOUtil.setDPI(metadata, dpi, formatName);
                }
            }
            if (metadata != null && formatName.equalsIgnoreCase("png") && ImageIOUtil.hasICCProfile(image)) {
                IIOMetadataNode iccp = new IIOMetadataNode("iCCP");
                ICC_Profile profile = ((ICC_ColorSpace)image.getColorModel().getColorSpace()).getProfile();
                iccp.setUserObject(ImageIOUtil.getAsDeflatedBytes(profile));
                iccp.setAttribute("profileName", "unknown");
                iccp.setAttribute("compressionMethod", "deflate");
                Node nativeTree = metadata.getAsTree(metadata.getNativeMetadataFormatName());
                nativeTree.appendChild(iccp);
                metadata.mergeTree(metadata.getNativeMetadataFormatName(), nativeTree);
            }
            imageOutput = ImageIO.createImageOutputStream(output);
            writer.setOutput(imageOutput);
            writer.write(null, new IIOImage(image, null, metadata), param);
        }
        finally {
            if (writer != null) {
                writer.dispose();
            }
            if (imageOutput != null) {
                imageOutput.close();
            }
        }
        return true;
    }

    private static boolean hasICCProfile(BufferedImage image) {
        ColorSpace colorSpace = image.getColorModel().getColorSpace();
        if (!(colorSpace instanceof ICC_ColorSpace)) {
            return false;
        }
        return !colorSpace.isCS_sRGB() && colorSpace != ColorSpace.getInstance(1003);
    }

    private static byte[] getAsDeflatedBytes(ICC_Profile profile) throws IOException {
        byte[] data = profile.getData();
        ByteArrayOutputStream deflated = new ByteArrayOutputStream();
        try (DeflaterOutputStream deflater = new DeflaterOutputStream(deflated);){
            deflater.write(data);
        }
        return deflated.toByteArray();
    }

    private static IIOMetadataNode getOrCreateChildNode(IIOMetadataNode parentNode, String name) {
        NodeList nodeList = parentNode.getElementsByTagName(name);
        if (nodeList.getLength() > 0) {
            return (IIOMetadataNode)nodeList.item(0);
        }
        IIOMetadataNode childNode = new IIOMetadataNode(name);
        parentNode.appendChild(childNode);
        return childNode;
    }

    private static void setDPI(IIOMetadata metadata, int dpi, String formatName) throws IIOInvalidTreeException {
        IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree("javax_imageio_1.0");
        IIOMetadataNode dimension = ImageIOUtil.getOrCreateChildNode(root, "Dimension");
        float res = "PNG".equalsIgnoreCase(formatName) ? (float)dpi / 25.4f : 25.4f / (float)dpi;
        IIOMetadataNode child = ImageIOUtil.getOrCreateChildNode(dimension, "HorizontalPixelSize");
        child.setAttribute("value", Double.toString(res));
        child = ImageIOUtil.getOrCreateChildNode(dimension, "VerticalPixelSize");
        child.setAttribute("value", Double.toString(res));
        metadata.mergeTree("javax_imageio_1.0", root);
    }
}

