/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import org.apache.commons.io.FilenameUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.multipdf.Splitter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.tools.Version;
import picocli.CommandLine;

@CommandLine.Command(name="pdfsplit", header={"Splits a PDF document into number of new documents"}, versionProvider=Version.class, mixinStandardHelpOptions=true)
public final class PDFSplit
implements Callable<Integer> {
    private static final PrintStream SYSERR = System.err;
    @CommandLine.Option(names={"-password"}, description={"the password to decrypt the document."}, arity="0..1", interactive=true)
    private String password;
    @CommandLine.Option(names={"-split"}, description={"split after this many pages (default 1, if startPage and endPage are unset)."})
    private int split = -1;
    @CommandLine.Option(names={"-startPage"}, description={"start page."})
    private int startPage = -1;
    @CommandLine.Option(names={"-endPage"}, description={"end page."})
    private int endPage = -1;
    @CommandLine.Option(names={"-outputPrefix"}, description={"the filename prefix for split files."})
    private String outputPrefix;
    @CommandLine.Option(names={"-i", "--input"}, description={"the PDF file to split"}, required=true)
    private File infile;

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        int exitCode = new CommandLine((Object)new PDFSplit()).execute(args);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() {
        Splitter splitter = new Splitter();
        if (this.outputPrefix == null) {
            this.outputPrefix = FilenameUtils.removeExtension((String)this.infile.getAbsolutePath());
        }
        Iterable documents = null;
        try (PDDocument document = Loader.loadPDF((File)this.infile, (String)this.password);){
            int numberOfPages = document.getNumberOfPages();
            boolean startEndPageSet = false;
            if (this.startPage != -1) {
                splitter.setStartPage(this.startPage);
                startEndPageSet = true;
                if (this.split == -1) {
                    splitter.setSplitAtPage(numberOfPages);
                }
            }
            if (this.endPage != -1) {
                splitter.setEndPage(this.endPage);
                startEndPageSet = true;
                if (this.split == -1) {
                    splitter.setSplitAtPage(this.endPage);
                }
            }
            if (this.split != -1) {
                splitter.setSplitAtPage(this.split);
            } else if (!startEndPageSet) {
                splitter.setSplitAtPage(1);
            }
            documents = splitter.split(document);
            for (int i = 0; i < documents.size(); ++i) {
                try (PDDocument doc = (PDDocument)documents.get(i);){
                    doc.save(this.outputPrefix + "-" + (i + 1) + ".pdf");
                    continue;
                }
            }
        }
        catch (IOException ioe) {
            SYSERR.println("Error splitting document [" + ioe.getClass().getSimpleName() + "]: " + ioe.getMessage());
            Integer n = 4;
            return n;
        }
        finally {
            if (documents != null) {
                documents.forEach(IOUtils::closeQuietly);
            }
        }
        return 0;
    }
}

