/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.RandomAccessStreamCache;
import org.apache.pdfbox.io.RandomAccessStreamCacheImpl;

public final class IOUtils {
    private static final Logger LOG = LogManager.getLogger(IOUtils.class);
    private static final RandomAccessStreamCache.StreamCacheCreateFunction streamCache = RandomAccessStreamCacheImpl::new;
    private static final Optional<Consumer<ByteBuffer>> UNMAPPER = Optional.ofNullable(AccessController.doPrivileged(IOUtils::unmapper));

    private IOUtils() {
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    public static byte[] toByteArray(InputStream in) throws IOException {
        return in.readAllBytes();
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    public static long copy(InputStream input, OutputStream output) throws IOException {
        return input.transferTo(output);
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    public static long populateBuffer(InputStream in, byte[] buffer) throws IOException {
        return in.readNBytes(buffer, 0, buffer.length);
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ioe) {
            LOG.debug("An exception occurred while trying to close - ignoring", (Throwable)ioe);
        }
    }

    public static IOException closeAndLogException(Closeable closeable, Logger logger, String resourceName, IOException initialException) {
        block2: {
            try {
                closeable.close();
            }
            catch (IOException ioe) {
                logger.warn("Error closing {}", (Object)resourceName, (Object)ioe);
                if (initialException != null) break block2;
                return ioe;
            }
        }
        return initialException;
    }

    public static void unmap(ByteBuffer buf) {
        try {
            if (buf != null) {
                UNMAPPER.ifPresent(u -> u.accept(buf));
            }
        }
        catch (Exception e) {
            LOG.error("Unable to unmap ByteBuffer.", (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Consumer<ByteBuffer> unmapper() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            MethodHandle unmapper = lookup.findVirtual(unsafeClass, "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class));
            Field f = unsafeClass.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            Object theUnsafe = f.get(null);
            return IOUtils.newBufferCleaner(ByteBuffer.class, unmapper.bindTo(theUnsafe));
        }
        catch (SecurityException se) {
            try {
                throw se;
                catch (ReflectiveOperationException | RuntimeException e) {
                    Class<?> directBufferClass = Class.forName("java.nio.DirectByteBuffer");
                    Method m = directBufferClass.getMethod("cleaner", new Class[0]);
                    m.setAccessible(true);
                    MethodHandle directBufferCleanerMethod = lookup.unreflect(m);
                    TypeDescriptor.OfField cleanerClass = directBufferCleanerMethod.type().returnType();
                    MethodHandle cleanMethod = lookup.findVirtual((Class<?>)cleanerClass, "clean", MethodType.methodType(Void.TYPE));
                    MethodHandle nonNullTest = lookup.findStatic(Objects.class, "nonNull", MethodType.methodType(Boolean.TYPE, Object.class)).asType(MethodType.methodType(Boolean.TYPE, cleanerClass));
                    MethodHandle noop = MethodHandles.dropArguments(MethodHandles.constant(Void.class, null).asType(MethodType.methodType(Void.TYPE)), 0, new Class[]{cleanerClass});
                    MethodHandle unmapper = MethodHandles.filterReturnValue(directBufferCleanerMethod, MethodHandles.guardWithTest(nonNullTest, cleanMethod, noop)).asType(MethodType.methodType(Void.TYPE, ByteBuffer.class));
                    return IOUtils.newBufferCleaner(directBufferClass, unmapper);
                }
            }
            catch (SecurityException se2) {
                LOG.error("Unmapping is not supported because of missing permissions. Please grant at least the following permissions: RuntimePermission(\"accessClassInPackage.sun.misc\")  and ReflectPermission(\"suppressAccessChecks\")", (Throwable)se2);
                return null;
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                LOG.error("Unmapping is not supported.", (Throwable)e);
            }
        }
        return null;
    }

    private static Consumer<ByteBuffer> newBufferCleaner(Class<?> unmappableBufferClass, MethodHandle unmapper) {
        assert (Objects.equals(MethodType.methodType(Void.TYPE, ByteBuffer.class), unmapper.type()));
        return buffer -> {
            if (!buffer.isDirect()) {
                throw new IllegalArgumentException("unmapping only works with direct buffers");
            }
            if (!unmappableBufferClass.isInstance(buffer)) {
                throw new IllegalArgumentException("buffer is not an instance of " + unmappableBufferClass.getName());
            }
            Throwable e = AccessController.doPrivileged(() -> {
                try {
                    unmapper.invokeExact((ByteBuffer)buffer);
                    return null;
                }
                catch (Throwable t) {
                    return t;
                }
            });
            if (Objects.nonNull(e)) {
                LOG.error("Unable to unmap the mapped buffer", e);
            }
        };
    }

    public static RandomAccessStreamCache.StreamCacheCreateFunction createMemoryOnlyStreamCache() {
        return streamCache;
    }

    public static RandomAccessStreamCache.StreamCacheCreateFunction createTempFileOnlyStreamCache() {
        return MemoryUsageSetting.setupTempFileOnly().streamCache;
    }
}

