/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.util;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.apache.pdfbox.pdmodel.graphics.blend.BlendMode;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;

public class AddWatermarkText {
    private AddWatermarkText() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            AddWatermarkText.usage();
        } else {
            File srcFile = new File(args[0]);
            File dstFile = new File(args[1]);
            String text = args[2];
            try (PDDocument doc = Loader.loadPDF((File)srcFile);){
                for (PDPage page : doc.getPages()) {
                    PDType1Font font = new PDType1Font(Standard14Fonts.FontName.HELVETICA);
                    AddWatermarkText.addWatermarkText(doc, page, (PDFont)font, text);
                }
                doc.save(dstFile);
            }
        }
    }

    private static void addWatermarkText(PDDocument doc, PDPage page, PDFont font, String text) throws IOException {
        try (PDPageContentStream cs = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, true, true);){
            float fontHeight = 100.0f;
            float width = page.getMediaBox().getWidth();
            float height = page.getMediaBox().getHeight();
            int rotation = page.getRotation();
            switch (rotation) {
                case 90: {
                    width = page.getMediaBox().getHeight();
                    height = page.getMediaBox().getWidth();
                    cs.transform(Matrix.getRotateInstance((double)Math.toRadians(90.0), (float)height, (float)0.0f));
                    break;
                }
                case 180: {
                    cs.transform(Matrix.getRotateInstance((double)Math.toRadians(180.0), (float)width, (float)height));
                    break;
                }
                case 270: {
                    width = page.getMediaBox().getHeight();
                    height = page.getMediaBox().getWidth();
                    cs.transform(Matrix.getRotateInstance((double)Math.toRadians(270.0), (float)0.0f, (float)width));
                    break;
                }
            }
            float stringWidth = font.getStringWidth(text) / 1000.0f * fontHeight;
            float diagonalLength = (float)Math.sqrt(width * width + height * height);
            float angle = (float)Math.atan2(height, width);
            float x = (diagonalLength - stringWidth) / 2.0f;
            float y = -fontHeight / 4.0f;
            cs.transform(Matrix.getRotateInstance((double)angle, (float)0.0f, (float)0.0f));
            cs.setFont(font, fontHeight);
            PDExtendedGraphicsState gs = new PDExtendedGraphicsState();
            gs.setNonStrokingAlphaConstant(Float.valueOf(0.2f));
            gs.setStrokingAlphaConstant(Float.valueOf(0.2f));
            gs.setBlendMode(BlendMode.MULTIPLY);
            gs.setLineWidth(Float.valueOf(3.0f));
            cs.setGraphicsStateParameters(gs);
            cs.setNonStrokingColor(Color.red);
            cs.setStrokingColor(Color.red);
            cs.beginText();
            cs.newLineAtOffset(x, y);
            cs.showText(text);
            cs.endText();
        }
    }

    private static void usage() {
        System.err.println("Usage: java " + AddWatermarkText.class.getName() + " <input-pdf> <output-pdf> <short text>");
    }
}

