/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.common.function.PDFunctionType2;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType2;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType3;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType4;

public class CreateGradientShadingPDF {
    public void create(String file) throws IOException {
        try (PDDocument document = new PDDocument();){
            PDPage page = new PDPage();
            document.addPage(page);
            COSDictionary fdict = new COSDictionary();
            fdict.setInt(COSName.FUNCTION_TYPE, 2);
            COSArray domain = new COSArray();
            domain.add((COSBase)COSInteger.ZERO);
            domain.add((COSBase)COSInteger.ONE);
            COSArray c0 = new COSArray();
            c0.add((COSBase)COSInteger.ONE);
            c0.add((COSBase)COSInteger.ZERO);
            c0.add((COSBase)COSInteger.ZERO);
            COSArray c1 = new COSArray();
            c1.add((COSBase)COSNumber.get((String)"0.5"));
            c1.add((COSBase)COSInteger.ONE);
            c1.add((COSBase)COSNumber.get((String)"0.5"));
            fdict.setItem(COSName.DOMAIN, (COSBase)domain);
            fdict.setItem(COSName.C0, (COSBase)c0);
            fdict.setItem(COSName.C1, (COSBase)c1);
            fdict.setInt(COSName.N, 1);
            PDFunctionType2 func = new PDFunctionType2((COSBase)fdict);
            PDShadingType2 axialShading = new PDShadingType2(new COSDictionary());
            axialShading.setColorSpace((PDColorSpace)PDDeviceRGB.INSTANCE);
            axialShading.setShadingType(2);
            COSArray coords1 = new COSArray();
            coords1.add((COSBase)COSInteger.get((long)100L));
            coords1.add((COSBase)COSInteger.get((long)400L));
            coords1.add((COSBase)COSInteger.get((long)400L));
            coords1.add((COSBase)COSInteger.get((long)600L));
            axialShading.setCoords(coords1);
            axialShading.setFunction((PDFunction)func);
            PDShadingType3 radialShading = new PDShadingType3(new COSDictionary());
            radialShading.setColorSpace((PDColorSpace)PDDeviceRGB.INSTANCE);
            radialShading.setShadingType(3);
            COSArray coords2 = new COSArray();
            coords2.add((COSBase)COSInteger.get((long)100L));
            coords2.add((COSBase)COSInteger.get((long)400L));
            coords2.add((COSBase)COSInteger.get((long)50L));
            coords2.add((COSBase)COSInteger.get((long)400L));
            coords2.add((COSBase)COSInteger.get((long)600L));
            coords2.add((COSBase)COSInteger.get((long)150L));
            radialShading.setCoords(coords2);
            radialShading.setFunction((PDFunction)func);
            PDShadingType4 gouraudShading = new PDShadingType4((COSDictionary)document.getDocument().createCOSStream());
            gouraudShading.setShadingType(4);
            gouraudShading.setBitsPerFlag(8);
            gouraudShading.setBitsPerCoordinate(16);
            gouraudShading.setBitsPerComponent(8);
            COSArray decodeArray = new COSArray();
            decodeArray.add((COSBase)COSInteger.ZERO);
            decodeArray.add((COSBase)COSInteger.get((long)65535L));
            decodeArray.add((COSBase)COSInteger.ZERO);
            decodeArray.add((COSBase)COSInteger.get((long)65535L));
            decodeArray.add((COSBase)COSInteger.ZERO);
            decodeArray.add((COSBase)COSInteger.ONE);
            decodeArray.add((COSBase)COSInteger.ZERO);
            decodeArray.add((COSBase)COSInteger.ONE);
            decodeArray.add((COSBase)COSInteger.ZERO);
            decodeArray.add((COSBase)COSInteger.ONE);
            gouraudShading.setDecodeValues(decodeArray);
            gouraudShading.setColorSpace((PDColorSpace)PDDeviceRGB.INSTANCE);
            try (OutputStream os = ((COSStream)gouraudShading.getCOSObject()).createOutputStream();
                 MemoryCacheImageOutputStream mcos = new MemoryCacheImageOutputStream(os);){
                mcos.writeByte(0);
                mcos.writeShort(0);
                mcos.writeShort(0);
                mcos.writeByte(255);
                mcos.writeByte(0);
                mcos.writeByte(0);
                mcos.writeByte(0);
                mcos.writeShort(100);
                mcos.writeShort(100);
                mcos.writeByte(0);
                mcos.writeByte(255);
                mcos.writeByte(0);
                mcos.writeByte(0);
                mcos.writeShort(200);
                mcos.writeShort(0);
                mcos.writeByte(0);
                mcos.writeByte(0);
                mcos.writeByte(255);
            }
            var17_19 = null;
            try (PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, false);){
                contentStream.shadingFill((PDShading)axialShading);
                contentStream.shadingFill((PDShading)radialShading);
                contentStream.shadingFill((PDShading)gouraudShading);
            }
            catch (Throwable throwable) {
                var17_19 = throwable;
                throw throwable;
            }
            document.save(file);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            CreateGradientShadingPDF.usage();
        } else {
            CreateGradientShadingPDF creator = new CreateGradientShadingPDF();
            creator.create(args[0]);
        }
    }

    private static void usage() {
        System.err.println("usage: java " + CreateGradientShadingPDF.class.getName() + " <outputfile.pdf>");
    }
}

