/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationCircle;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationFreeText;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationHighlight;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLine;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationPolygon;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationSquare;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitWidthDestination;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;

public final class AddAnnotations {
    static final float INCH = 72.0f;

    private AddAnnotations() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.err.println("Usage: " + AddAnnotations.class.getName() + " <output-pdf>");
            System.exit(1);
        }
        try (PDDocument document = new PDDocument();){
            PDResources dr;
            float[] quads;
            PDPage page1 = new PDPage();
            PDPage page2 = new PDPage();
            PDPage page3 = new PDPage();
            document.addPage(page1);
            document.addPage(page2);
            document.addPage(page3);
            List annotations = page1.getAnnotations();
            PDColor red = new PDColor(new float[]{1.0f, 0.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
            PDColor blue = new PDColor(new float[]{0.0f, 0.0f, 1.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
            PDColor green = new PDColor(new float[]{0.0f, 1.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
            PDColor black = new PDColor(new float[]{0.0f, 0.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
            PDBorderStyleDictionary borderThick = new PDBorderStyleDictionary();
            borderThick.setWidth(6.0f);
            PDBorderStyleDictionary borderThin = new PDBorderStyleDictionary();
            borderThin.setWidth(1.0f);
            PDBorderStyleDictionary borderULine = new PDBorderStyleDictionary();
            borderULine.setStyle("U");
            borderULine.setWidth(1.0f);
            float pw = page1.getMediaBox().getUpperRightX();
            float ph = page1.getMediaBox().getUpperRightY();
            PDType1Font font = new PDType1Font(Standard14Fonts.FontName.HELVETICA_BOLD);
            try (PDPageContentStream contents = new PDPageContentStream(document, page1);){
                contents.beginText();
                contents.setFont((PDFont)font, 18.0f);
                contents.newLineAtOffset(72.0f, ph - 72.0f - 18.0f);
                contents.showText("PDFBox");
                contents.newLineAtOffset(0.0f, -36.0f);
                contents.showText("External URL");
                contents.newLineAtOffset(0.0f, -36.0f);
                contents.showText("Jump to page three");
                contents.endText();
            }
            PDAnnotationHighlight txtHighlight = new PDAnnotationHighlight();
            txtHighlight.setColor(new PDColor(new float[]{0.0f, 1.0f, 1.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
            txtHighlight.setConstantOpacity(0.2f);
            float textWidth = font.getStringWidth("PDFBox") / 1000.0f * 18.0f;
            PDRectangle position = new PDRectangle();
            position.setLowerLeftX(72.0f);
            position.setLowerLeftY(ph - 72.0f - 18.0f);
            position.setUpperRightX(72.0f + textWidth);
            position.setUpperRightY(ph - 72.0f);
            txtHighlight.setRectangle(position);
            quads = new float[]{position.getLowerLeftX(), position.getUpperRightY() - 2.0f, position.getUpperRightX(), quads[1], quads[0], position.getLowerLeftY() - 2.0f, quads[2], quads[5]};
            txtHighlight.setQuadPoints(quads);
            txtHighlight.setContents("Highlighted since it's important");
            annotations.add(txtHighlight);
            PDAnnotationLink txtLink = new PDAnnotationLink();
            txtLink.setBorderStyle(borderULine);
            textWidth = font.getStringWidth("External URL") / 1000.0f * 18.0f;
            position = new PDRectangle();
            position.setLowerLeftX(72.0f);
            position.setLowerLeftY(ph - 108.0f - 20.0f);
            position.setUpperRightX(72.0f + textWidth);
            position.setUpperRightY(ph - 108.0f);
            txtLink.setRectangle(position);
            PDActionURI action = new PDActionURI();
            action.setURI("http://pdfbox.apache.org");
            txtLink.setAction((PDAction)action);
            annotations.add(txtLink);
            PDAnnotationCircle aCircle = new PDAnnotationCircle();
            aCircle.setContents("Circle Annotation");
            aCircle.setInteriorColor(red);
            aCircle.setColor(blue);
            aCircle.setBorderStyle(borderThin);
            position = new PDRectangle();
            position.setLowerLeftX(72.0f);
            position.setLowerLeftY(ph - 216.0f - 72.0f);
            position.setUpperRightX(144.0f);
            position.setUpperRightY(ph - 216.0f);
            aCircle.setRectangle(position);
            annotations.add(aCircle);
            PDAnnotationSquare aSquare = new PDAnnotationSquare();
            aSquare.setContents("Square Annotation");
            aSquare.setColor(red);
            aSquare.setBorderStyle(borderThick);
            position = new PDRectangle();
            position.setLowerLeftX(pw - 144.0f);
            position.setLowerLeftY(ph - 252.0f - 72.0f);
            position.setUpperRightX(pw - 72.0f);
            position.setUpperRightY(ph - 252.0f);
            aSquare.setRectangle(position);
            annotations.add(aSquare);
            PDAnnotationLine aLine = new PDAnnotationLine();
            aLine.setEndPointEndingStyle("OpenArrow");
            aLine.setContents("Circle->Square");
            aLine.setCaption(true);
            position = new PDRectangle();
            position.setLowerLeftX(144.0f);
            position.setLowerLeftY(ph - 252.0f - 72.0f);
            position.setUpperRightX(pw - 72.0f - 72.0f);
            position.setUpperRightY(ph - 216.0f);
            aLine.setRectangle(position);
            float[] linepos = new float[]{144.0f, ph - 252.0f, pw - 144.0f, ph - 288.0f};
            aLine.setLine(linepos);
            aLine.setBorderStyle(borderThick);
            aLine.setColor(black);
            annotations.add(aLine);
            PDAnnotationLink pageLink = new PDAnnotationLink();
            pageLink.setBorderStyle(borderULine);
            textWidth = font.getStringWidth("Jump to page three") / 1000.0f * 18.0f;
            position = new PDRectangle();
            position.setLowerLeftX(72.0f);
            position.setLowerLeftY(ph - 144.0f - 20.0f);
            position.setUpperRightX(72.0f + textWidth);
            position.setUpperRightY(ph - 144.0f);
            pageLink.setRectangle(position);
            PDActionGoTo actionGoto = new PDActionGoTo();
            PDPageFitWidthDestination dest = new PDPageFitWidthDestination();
            dest.setPage(page3);
            actionGoto.setDestination((PDDestination)dest);
            pageLink.setAction((PDAction)actionGoto);
            annotations.add(pageLink);
            PDAnnotationFreeText freeTextAnnotation = new PDAnnotationFreeText();
            PDColor yellow = new PDColor(new float[]{1.0f, 1.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
            freeTextAnnotation.setColor(yellow);
            position = new PDRectangle();
            position.setLowerLeftX(72.0f);
            position.setLowerLeftY(ph - 360.0f - 216.0f);
            position.setUpperRightX(pw - 72.0f);
            position.setUpperRightY(ph - 360.0f);
            freeTextAnnotation.setRectangle(position);
            freeTextAnnotation.setTitlePopup("Sophia Lorem");
            freeTextAnnotation.setSubject("Lorem ipsum");
            freeTextAnnotation.setContents("uppercase \u0394, lowercase \u03b4\nLorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.");
            freeTextAnnotation.setDefaultAppearance("0 0 1 rg /LibSans 20 Tf");
            freeTextAnnotation.setQ(2);
            freeTextAnnotation.setIntent("FreeTextCallout");
            freeTextAnnotation.setCallout(new float[]{0.0f, ph - 648.0f, 216.0f, ph - 648.0f, 288.0f, ph - 576.0f});
            freeTextAnnotation.setLineEndingStyle("OpenArrow");
            annotations.add(freeTextAnnotation);
            PDAnnotationPolygon polygon = new PDAnnotationPolygon();
            position = new PDRectangle();
            position.setLowerLeftX(pw - 72.0f);
            position.setLowerLeftY(ph - 72.0f);
            position.setUpperRightX(pw - 144.0f);
            position.setUpperRightY(ph - 144.0f);
            polygon.setRectangle(position);
            polygon.setColor(blue);
            polygon.setInteriorColor(green);
            float[] vertices = new float[]{pw - 72.0f, ph - 144.0f, pw - 108.0f, ph - 72.0f, pw - 144.0f, ph - 144.0f};
            polygon.setVertices(vertices);
            polygon.setBorderStyle(borderThick);
            polygon.setContents("Polygon annotation");
            annotations.add(polygon);
            PDAcroForm acroForm = document.getDocumentCatalog().getAcroForm();
            if (acroForm == null) {
                acroForm = new PDAcroForm(document);
                document.getDocumentCatalog().setAcroForm(acroForm);
            }
            if ((dr = acroForm.getDefaultResources()) == null) {
                dr = new PDResources();
                acroForm.setDefaultResources(dr);
            }
            dr.put(COSName.HELV, (PDFont)new PDType1Font(Standard14Fonts.FontName.HELVETICA));
            PDType0Font libSansFont = PDType0Font.load((PDDocument)document, (InputStream)AddAnnotations.class.getResourceAsStream("/org/apache/pdfbox/resources/ttf/LiberationSans-Regular.ttf"), (boolean)false);
            dr.put(COSName.getPDFName((String)"LibSans"), (PDFont)libSansFont);
            annotations.forEach(ann -> ann.constructAppearances(document));
            AddAnnotations.showPageNo(document, page1, "Page 1");
            AddAnnotations.showPageNo(document, page2, "Page 2");
            AddAnnotations.showPageNo(document, page3, "Page 3");
            document.save(args[0]);
        }
    }

    private static void showPageNo(PDDocument document, PDPage page, String pageText) throws IOException {
        int fontSize = 10;
        try (PDPageContentStream contents = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.PREPEND, true);){
            float pageWidth = page.getMediaBox().getWidth();
            float pageHeight = page.getMediaBox().getHeight();
            PDType1Font font = new PDType1Font(Standard14Fonts.FontName.HELVETICA);
            contents.setFont((PDFont)font, (float)fontSize);
            float textWidth = font.getStringWidth(pageText) / 1000.0f * (float)fontSize;
            contents.beginText();
            contents.newLineAtOffset(pageWidth / 2.0f - textWidth / 2.0f, pageHeight - 36.0f);
            contents.showText(pageText);
            contents.endText();
        }
    }
}

