/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public final class ImageToPDF {
    private ImageToPDF() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("usage: " + ImageToPDF.class.getName() + " <image> <output-file>");
            System.exit(1);
        }
        String imagePath = args[0];
        String pdfPath = args[1];
        if (!pdfPath.endsWith(".pdf")) {
            System.err.println("Last argument must be the destination .pdf file");
            System.exit(1);
        }
        try (PDDocument doc = new PDDocument();){
            PDPage page = new PDPage();
            doc.addPage(page);
            PDImageXObject pdImage = PDImageXObject.createFromFile((String)imagePath, (PDDocument)doc);
            try (PDPageContentStream contents = new PDPageContentStream(doc, page);){
                contents.drawImage(pdImage, 20.0f, 20.0f);
            }
            doc.save(pdfPath);
        }
    }
}

