/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PageMode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;

public class EmbeddedFiles {
    private EmbeddedFiles() {
    }

    public void doIt(String file) throws IOException {
        try (PDDocument doc = new PDDocument();){
            PDPage page = new PDPage();
            doc.addPage(page);
            PDType1Font font = new PDType1Font(Standard14Fonts.FontName.HELVETICA_BOLD);
            try (PDPageContentStream contentStream = new PDPageContentStream(doc, page);){
                contentStream.beginText();
                contentStream.setFont((PDFont)font, 12.0f);
                contentStream.newLineAtOffset(100.0f, 700.0f);
                contentStream.showText("Go to Document->File Attachments to View Embedded Files");
                contentStream.endText();
            }
            PDEmbeddedFilesNameTreeNode efTree = new PDEmbeddedFilesNameTreeNode();
            PDComplexFileSpecification fs = new PDComplexFileSpecification();
            fs.setFile("Test.txt");
            fs.setFileUnicode("Test.txt");
            byte[] data = "This is the contents of the embedded file".getBytes(StandardCharsets.ISO_8859_1);
            ByteArrayInputStream fakeFile = new ByteArrayInputStream(data);
            PDEmbeddedFile ef = new PDEmbeddedFile(doc, (InputStream)fakeFile);
            ef.setSubtype("text/plain");
            ef.setSize(data.length);
            ef.setCreationDate((Calendar)new GregorianCalendar());
            fs.setEmbeddedFile(ef);
            fs.setEmbeddedFileUnicode(ef);
            fs.setFileDescription("Very interesting file");
            PDEmbeddedFilesNameTreeNode treeNode = new PDEmbeddedFilesNameTreeNode();
            treeNode.setNames(Collections.singletonMap("My first attachment", fs));
            ArrayList<PDEmbeddedFilesNameTreeNode> kids = new ArrayList<PDEmbeddedFilesNameTreeNode>();
            kids.add(treeNode);
            efTree.setKids(kids);
            PDDocumentNameDictionary names = new PDDocumentNameDictionary(doc.getDocumentCatalog());
            names.setEmbeddedFiles(efTree);
            doc.getDocumentCatalog().setNames(names);
            doc.getDocumentCatalog().setPageMode(PageMode.USE_ATTACHMENTS);
            doc.save(file);
        }
    }

    public static void main(String[] args) throws IOException {
        EmbeddedFiles app = new EmbeddedFiles();
        if (args.length != 1) {
            app.usage();
        } else {
            app.doIt(args[0]);
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <output-file>");
    }
}

