/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PageMode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;

public class CreatePortableCollection {
    private CreatePortableCollection() {
    }

    public void doIt(String file) throws IOException {
        try (PDDocument doc = new PDDocument();){
            PDPage page = new PDPage();
            doc.addPage(page);
            try (PDPageContentStream contentStream = new PDPageContentStream(doc, page);){
                contentStream.beginText();
                contentStream.setFont((PDFont)new PDType1Font(Standard14Fonts.FontName.HELVETICA), 12.0f);
                contentStream.newLineAtOffset(100.0f, 700.0f);
                contentStream.showText("Example of a portable collection");
                contentStream.endText();
            }
            PDEmbeddedFilesNameTreeNode efTree = new PDEmbeddedFilesNameTreeNode();
            PDComplexFileSpecification fs1 = new PDComplexFileSpecification();
            fs1.setFile("Test1.txt");
            fs1.setFileUnicode("Test1.txt");
            byte[] data1 = "This is the contents of the first embedded file".getBytes(StandardCharsets.ISO_8859_1);
            PDEmbeddedFile ef1 = new PDEmbeddedFile(doc, (InputStream)new ByteArrayInputStream(data1), COSName.FLATE_DECODE);
            ef1.setSubtype("text/plain");
            ef1.setSize(data1.length);
            ef1.setCreationDate((Calendar)new GregorianCalendar());
            fs1.setEmbeddedFile(ef1);
            fs1.setEmbeddedFileUnicode(ef1);
            fs1.setFileDescription("The first file");
            PDComplexFileSpecification fs2 = new PDComplexFileSpecification();
            fs2.setFile("Test2.txt");
            fs2.setFileUnicode("Test2.txt");
            byte[] data2 = "This is the contents of the second embedded file".getBytes(StandardCharsets.ISO_8859_1);
            PDEmbeddedFile ef2 = new PDEmbeddedFile(doc, (InputStream)new ByteArrayInputStream(data2), COSName.FLATE_DECODE);
            ef2.setSubtype("text/plain");
            ef2.setSize(data2.length);
            ef2.setCreationDate((Calendar)new GregorianCalendar());
            fs2.setEmbeddedFile(ef2);
            fs2.setEmbeddedFileUnicode(ef2);
            fs2.setFileDescription("The second file");
            HashMap<String, PDComplexFileSpecification> map = new HashMap<String, PDComplexFileSpecification>();
            map.put("Attachment 1", fs1);
            map.put("Attachment 2", fs2);
            PDEmbeddedFilesNameTreeNode treeNode = new PDEmbeddedFilesNameTreeNode();
            treeNode.setNames(map);
            ArrayList<PDEmbeddedFilesNameTreeNode> kids = new ArrayList<PDEmbeddedFilesNameTreeNode>();
            kids.add(treeNode);
            efTree.setKids(kids);
            PDDocumentNameDictionary names = new PDDocumentNameDictionary(doc.getDocumentCatalog());
            names.setEmbeddedFiles(efTree);
            doc.getDocumentCatalog().setNames(names);
            doc.getDocumentCatalog().setPageMode(PageMode.USE_ATTACHMENTS);
            COSDictionary collectionDic = new COSDictionary();
            COSDictionary schemaDict = new COSDictionary();
            schemaDict.setItem(COSName.TYPE, (COSBase)COSName.COLLECTION_SCHEMA);
            COSDictionary sortDic = new COSDictionary();
            sortDic.setItem(COSName.TYPE, (COSBase)COSName.COLLECTION_SORT);
            sortDic.setString(COSName.A, "true");
            sortDic.setItem(COSName.S, (COSBase)COSName.getPDFName((String)"fieldtwo"));
            collectionDic.setItem(COSName.TYPE, (COSBase)COSName.COLLECTION);
            collectionDic.setItem(COSName.SCHEMA, (COSBase)schemaDict);
            collectionDic.setItem(COSName.SORT, (COSBase)sortDic);
            collectionDic.setItem(COSName.VIEW, (COSBase)COSName.D);
            COSDictionary fieldDict1 = new COSDictionary();
            fieldDict1.setItem(COSName.TYPE, (COSBase)COSName.COLLECTION_FIELD);
            fieldDict1.setItem(COSName.SUBTYPE, (COSBase)COSName.S);
            fieldDict1.setString(COSName.N, "field header one (description)");
            fieldDict1.setInt(COSName.O, 1);
            COSDictionary fieldDict2 = new COSDictionary();
            fieldDict2.setItem(COSName.TYPE, (COSBase)COSName.COLLECTION_FIELD);
            fieldDict2.setItem(COSName.SUBTYPE, (COSBase)COSName.S);
            fieldDict2.setString(COSName.N, "field header two (name)");
            fieldDict2.setInt(COSName.O, 2);
            COSDictionary fieldDict3 = new COSDictionary();
            fieldDict3.setItem(COSName.TYPE, (COSBase)COSName.COLLECTION_FIELD);
            fieldDict3.setItem(COSName.SUBTYPE, (COSBase)COSName.N);
            fieldDict3.setString(COSName.N, "field header three (size)");
            fieldDict3.setInt(COSName.O, 3);
            schemaDict.setItem("fieldone", (COSBase)fieldDict1);
            schemaDict.setItem("fieldtwo", (COSBase)fieldDict2);
            schemaDict.setItem("fieldthree", (COSBase)fieldDict3);
            doc.getDocumentCatalog().getCOSObject().setItem(COSName.COLLECTION, (COSBase)collectionDic);
            doc.getDocumentCatalog().setVersion("1.7");
            COSDictionary ciDict1 = new COSDictionary();
            ciDict1.setItem(COSName.TYPE, (COSBase)COSName.COLLECTION_ITEM);
            ciDict1.setString("fieldone", fs1.getFileDescription());
            ciDict1.setString("fieldtwo", fs1.getFile());
            ciDict1.setInt("fieldthree", fs1.getEmbeddedFile().getSize());
            fs1.getCOSObject().setItem(COSName.CI, (COSBase)ciDict1);
            COSDictionary ciDict2 = new COSDictionary();
            ciDict2.setItem(COSName.TYPE, (COSBase)COSName.COLLECTION_ITEM);
            ciDict2.setString("fieldone", fs2.getFileDescription());
            ciDict2.setString("fieldtwo", fs2.getFile());
            ciDict2.setInt("fieldthree", fs2.getEmbeddedFile().getSize());
            fs2.getCOSObject().setItem(COSName.CI, (COSBase)ciDict2);
            doc.save(file);
        }
    }

    public static void main(String[] args) throws IOException {
        CreatePortableCollection app = new CreatePortableCollection();
        if (args.length != 1) {
            app.usage();
        } else {
            app.doIt(args[0]);
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <output-file>");
    }
}

