/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;

public class BengaliPdfGenerationHelloWorld {
    private static final int LINE_GAP = 5;
    private static final String LOHIT_BENGALI_TTF = "/org/apache/pdfbox/resources/ttf/Lohit-Bengali.ttf";
    private static final String TEXT_SOURCE_FILE = "/org/apache/pdfbox/resources/ttf/bengali-samples.txt";
    private static final int FONT_SIZE = 20;
    private static final int MARGIN = 20;

    private BengaliPdfGenerationHelloWorld() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.err.println("usage: " + BengaliPdfGenerationHelloWorld.class.getName() + " <output-file> ");
            System.exit(1);
        }
        String filename = args[0];
        System.out.println("The generated pdf filename is: " + filename);
        try (PDDocument doc = new PDDocument();){
            PDType0Font font = PDType0Font.load((PDDocument)doc, (InputStream)BengaliPdfGenerationHelloWorld.class.getResourceAsStream(LOHIT_BENGALI_TTF), (boolean)true);
            PDRectangle rectangle = BengaliPdfGenerationHelloWorld.getPageSize();
            float workablePageWidth = rectangle.getWidth() - 40.0f;
            float workablePageHeight = rectangle.getHeight() - 40.0f;
            List<List<String>> pagedTexts = BengaliPdfGenerationHelloWorld.getReAlignedTextBasedOnPageHeight(BengaliPdfGenerationHelloWorld.getReAlignedTextBasedOnPageWidth(BengaliPdfGenerationHelloWorld.getBengaliTextFromFile(), (PDFont)font, workablePageWidth), (PDFont)font, workablePageHeight);
            for (List<String> linesForPage : pagedTexts) {
                PDPage page = new PDPage(BengaliPdfGenerationHelloWorld.getPageSize());
                doc.addPage(page);
                PDPageContentStream contents = new PDPageContentStream(doc, page);
                Throwable throwable = null;
                try {
                    contents.beginText();
                    contents.setFont((PDFont)font, 20.0f);
                    contents.newLineAtOffset(rectangle.getLowerLeftX() + 20.0f, rectangle.getUpperRightY() - 20.0f);
                    for (String line : linesForPage) {
                        contents.showText(line);
                        contents.newLineAtOffset(0.0f, -25.0f);
                    }
                    contents.endText();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (contents == null) continue;
                    if (throwable != null) {
                        try {
                            contents.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    contents.close();
                }
            }
            doc.save(filename);
        }
    }

    private static List<List<String>> getReAlignedTextBasedOnPageHeight(List<String> originalLines, PDFont font, float workablePageHeight) {
        float newLineHeight = font.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * 20.0f + 5.0f;
        ArrayList<List<String>> realignedTexts = new ArrayList<List<String>>();
        float consumedHeight = 0.0f;
        ArrayList<String> linesInAPage = new ArrayList<String>();
        for (String line : originalLines) {
            if (newLineHeight + consumedHeight < workablePageHeight) {
                consumedHeight += newLineHeight;
            } else {
                consumedHeight = newLineHeight;
                realignedTexts.add(linesInAPage);
                linesInAPage = new ArrayList();
            }
            linesInAPage.add(line);
        }
        realignedTexts.add(linesInAPage);
        return realignedTexts;
    }

    private static List<String> getReAlignedTextBasedOnPageWidth(List<String> originalLines, PDFont font, float workablePageWidth) throws IOException {
        ArrayList<String> uniformlyWideTexts = new ArrayList<String>();
        float consumedWidth = 0.0f;
        StringBuilder sb = new StringBuilder();
        for (String line : originalLines) {
            float newTokenWidth = 0.0f;
            StringTokenizer st = new StringTokenizer(line, " ", true);
            while (st.hasMoreElements()) {
                String token = st.nextToken();
                newTokenWidth = font.getStringWidth(token) / 1000.0f * 20.0f;
                if (newTokenWidth + consumedWidth < workablePageWidth) {
                    consumedWidth += newTokenWidth;
                } else {
                    uniformlyWideTexts.add(sb.toString());
                    consumedWidth = newTokenWidth;
                    sb = new StringBuilder();
                }
                sb.append(token);
            }
            uniformlyWideTexts.add(sb.toString());
            consumedWidth = newTokenWidth;
            sb = new StringBuilder();
        }
        return uniformlyWideTexts;
    }

    private static PDRectangle getPageSize() {
        return PDRectangle.A4;
    }

    private static List<String> getBengaliTextFromFile() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(BengaliPdfGenerationHelloWorld.class.getResourceAsStream(TEXT_SOURCE_FILE), StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                lines.add(line);
            }
        }
        return lines;
    }
}

