/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.lucene;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Date;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.pdfbox.examples.lucene.LucenePDFDocument;

public final class IndexPDFFiles {
    private IndexPDFFiles() {
    }

    public static void main(String[] args) {
        File docDir;
        String usage = "java org.apache.pdfbox.lucene.IndexPDFFiles [-index INDEX_PATH] [-docs DOCS_PATH] [-update]\n\nThis indexes all PDF documents in DOCS_PATH, creating a Lucene indexin INDEX_PATH that can be searched with SearchFiles";
        String indexPath = "index";
        String docsPath = null;
        boolean create = true;
        for (int i = 0; i < args.length; ++i) {
            if ("-index".equals(args[i]) && i + 1 < args.length) {
                indexPath = args[i + 1];
                ++i;
                continue;
            }
            if ("-docs".equals(args[i]) && i + 1 < args.length) {
                docsPath = args[i + 1];
                ++i;
                continue;
            }
            if (!"-update".equals(args[i])) continue;
            create = false;
        }
        if (docsPath == null) {
            System.err.println("Usage: " + usage);
            System.exit(1);
        }
        if (!(docDir = new File(docsPath)).exists() || !docDir.canRead()) {
            System.out.println("Document directory '" + docDir.getAbsolutePath() + "' does not exist or is not readable, please check the path");
            System.exit(1);
        }
        Date start = new Date();
        try {
            System.out.println("Indexing to directory '" + indexPath + "'...");
            try (FSDirectory dir = FSDirectory.open((Path)new File(indexPath).toPath());){
                StandardAnalyzer analyzer = new StandardAnalyzer();
                IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)analyzer);
                if (create) {
                    iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
                } else {
                    iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
                }
                try (IndexWriter writer = new IndexWriter((Directory)dir, iwc);){
                    IndexPDFFiles.indexDocs(writer, docDir);
                }
            }
            Date end = new Date();
            System.out.println(end.getTime() - start.getTime() + " total milliseconds");
        }
        catch (IOException e) {
            System.out.println(" caught a " + e.getClass() + "\n with message: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void indexDocs(IndexWriter writer, File file) throws IOException {
        block9: {
            FileInputStream fis;
            block10: {
                if (!file.canRead()) break block9;
                if (!file.isDirectory()) break block10;
                String[] files = file.list();
                if (files == null) break block9;
                for (String fileName : files) {
                    IndexPDFFiles.indexDocs(writer, new File(file, fileName));
                }
                break block9;
            }
            try {
                fis = new FileInputStream(file);
            }
            catch (FileNotFoundException fnfe) {
                return;
            }
            try {
                String path = file.getName().toUpperCase();
                if (!path.toLowerCase().endsWith(".pdf")) {
                    System.out.println("Skipping " + file);
                    return;
                }
                System.out.println("Indexing PDF document: " + file);
                Document doc = LucenePDFDocument.getDocument(file);
                if (writer.getConfig().getOpenMode() == IndexWriterConfig.OpenMode.CREATE) {
                    System.out.println("adding " + file);
                    writer.addDocument((Iterable)doc);
                }
                System.out.println("updating " + file);
                writer.updateDocument(new Term("uid", LucenePDFDocument.createUID(file)), (Iterable)doc);
            }
            finally {
                fis.close();
            }
        }
    }
}

