/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.interactive.form;

import java.io.File;
import java.io.IOException;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionJavaScript;
import org.apache.pdfbox.pdmodel.interactive.action.PDAnnotationAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.action.PDFormFieldAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;

public final class FieldTriggers {
    private FieldTriggers() {
    }

    public static void main(String[] args) throws IOException {
        try (PDDocument document = Loader.loadPDF((File)new File("target/SimpleForm.pdf"));){
            PDAcroForm acroForm = document.getDocumentCatalog().getAcroForm();
            PDField field = acroForm.getField("SampleField");
            PDAnnotationWidget widget = (PDAnnotationWidget)field.getWidgets().get(0);
            PDAnnotationAdditionalActions annotationActions = new PDAnnotationAdditionalActions();
            PDActionJavaScript jsEnterAction = new PDActionJavaScript();
            jsEnterAction.setAction("app.alert(\"On 'enter' action\")");
            annotationActions.setE((PDAction)jsEnterAction);
            PDActionJavaScript jsExitAction = new PDActionJavaScript();
            jsExitAction.setAction("app.alert(\"On 'exit' action\")");
            annotationActions.setX((PDAction)jsExitAction);
            PDActionJavaScript jsMouseDownAction = new PDActionJavaScript();
            jsMouseDownAction.setAction("app.alert(\"On 'mouse down' action\")");
            annotationActions.setD((PDAction)jsMouseDownAction);
            PDActionJavaScript jsMouseUpAction = new PDActionJavaScript();
            jsMouseUpAction.setAction("app.alert(\"On 'mouse up' action\")");
            annotationActions.setU((PDAction)jsMouseUpAction);
            PDActionJavaScript jsFocusAction = new PDActionJavaScript();
            jsFocusAction.setAction("app.alert(\"On 'focus' action\")");
            annotationActions.setFo((PDAction)jsFocusAction);
            PDActionJavaScript jsBlurredAction = new PDActionJavaScript();
            jsBlurredAction.setAction("app.alert(\"On 'blurred' action\")");
            annotationActions.setBl((PDAction)jsBlurredAction);
            widget.setActions(annotationActions);
            PDFormFieldAdditionalActions fieldActions = new PDFormFieldAdditionalActions();
            PDActionJavaScript jsKeystrokeAction = new PDActionJavaScript();
            jsKeystrokeAction.setAction("app.alert(\"On 'keystroke' action\")");
            fieldActions.setK((PDAction)jsKeystrokeAction);
            PDActionJavaScript jsFormattedAction = new PDActionJavaScript();
            jsFormattedAction.setAction("app.alert(\"On 'formatted' action\")");
            fieldActions.setF((PDAction)jsFormattedAction);
            PDActionJavaScript jsChangedAction = new PDActionJavaScript();
            jsChangedAction.setAction("app.alert(\"On 'change' action\")");
            PDActionJavaScript jsRecalculateAction = new PDActionJavaScript();
            jsRecalculateAction.setAction("app.alert(\"On 'recalculate' action\")");
            fieldActions.setC((PDAction)jsRecalculateAction);
            field.getActions().getCOSObject().addAll(fieldActions.getCOSObject());
            document.save("target/FieldTriggers.pdf");
        }
    }
}

