/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.interactive.form;

import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceCharacteristicsDictionary;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDTextField;

public class CreateSimpleFormWithEmbeddedFont {
    private CreateSimpleFormWithEmbeddedFont() {
    }

    public static void main(String[] args) throws IOException {
        try (PDDocument doc = new PDDocument();){
            PDPage page = new PDPage(PDRectangle.A4);
            doc.addPage(page);
            PDAcroForm acroForm = new PDAcroForm(doc);
            doc.getDocumentCatalog().setAcroForm(acroForm);
            PDType0Font formFont = PDType0Font.load((PDDocument)doc, (InputStream)CreateSimpleFormWithEmbeddedFont.class.getResourceAsStream("/org/apache/pdfbox/resources/ttf/LiberationSans-Regular.ttf"), (boolean)false);
            PDResources resources = new PDResources();
            acroForm.setDefaultResources(resources);
            String fontName = resources.add((PDFont)formFont).getName();
            acroForm.setDefaultResources(resources);
            String defaultAppearanceString = "/" + fontName + " 0 Tf 0 g";
            PDTextField textBox = new PDTextField(acroForm);
            textBox.setPartialName("SampleField");
            textBox.setDefaultAppearance(defaultAppearanceString);
            acroForm.getFields().add(textBox);
            PDAnnotationWidget widget = (PDAnnotationWidget)textBox.getWidgets().get(0);
            PDRectangle rect = new PDRectangle(50.0f, 700.0f, 200.0f, 50.0f);
            widget.setRectangle(rect);
            widget.setPage(page);
            page.getAnnotations().add(widget);
            PDAppearanceCharacteristicsDictionary fieldAppearance = new PDAppearanceCharacteristicsDictionary(new COSDictionary());
            fieldAppearance.setBorderColour(new PDColor(new float[]{0.0f, 1.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
            fieldAppearance.setBackground(new PDColor(new float[]{1.0f, 1.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
            widget.setAppearanceCharacteristics(fieldAppearance);
            textBox.setValue("Sample field \u0130");
            try (PDPageContentStream cs = new PDPageContentStream(doc, page);){
                cs.beginText();
                cs.setFont((PDFont)new PDType1Font(Standard14Fonts.FontName.HELVETICA), 15.0f);
                cs.newLineAtOffset(50.0f, 760.0f);
                cs.showText("Field:");
                cs.endText();
            }
            doc.save("target/SimpleFormWithEmbeddedFont.pdf");
        }
    }
}

