/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.interactive.form;

import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import org.apache.fontbox.afm.CharMetric;
import org.apache.fontbox.afm.FontMetrics;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDAppearanceContentStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.apache.pdfbox.pdmodel.font.encoding.GlyphList;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceCharacteristicsDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDCheckBox;

public class CreateCheckBox {
    private CreateCheckBox() {
    }

    public static void main(String[] args) throws IOException {
        try (PDDocument document = new PDDocument();){
            PDPage page = new PDPage();
            document.addPage(page);
            PDAcroForm acroForm = new PDAcroForm(document);
            document.getDocumentCatalog().setAcroForm(acroForm);
            float x = 50.0f;
            float y = page.getMediaBox().getHeight() - 50.0f;
            PDRectangle rect = new PDRectangle(x, y, 20.0f, 20.0f);
            PDCheckBox checkbox = new PDCheckBox(acroForm);
            checkbox.setPartialName("MyCheckBox");
            PDAnnotationWidget widget = (PDAnnotationWidget)checkbox.getWidgets().get(0);
            widget.setPage(page);
            widget.setRectangle(rect);
            widget.setPrinted(true);
            PDAppearanceCharacteristicsDictionary appearanceCharacteristics = new PDAppearanceCharacteristicsDictionary(new COSDictionary());
            appearanceCharacteristics.setBorderColour(new PDColor(new float[]{1.0f, 0.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
            appearanceCharacteristics.setBackground(new PDColor(new float[]{1.0f, 1.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE));
            appearanceCharacteristics.setNormalCaption("4");
            widget.setAppearanceCharacteristics(appearanceCharacteristics);
            PDBorderStyleDictionary borderStyleDictionary = new PDBorderStyleDictionary();
            borderStyleDictionary.setWidth(1.0f);
            borderStyleDictionary.setStyle("S");
            widget.setBorderStyle(borderStyleDictionary);
            PDAppearanceDictionary ap = new PDAppearanceDictionary();
            widget.setAppearance(ap);
            PDAppearanceEntry normalAppearance = ap.getNormalAppearance();
            COSDictionary normalAppearanceDict = normalAppearance.getCOSObject();
            PDType1Font zapfDingbats = new PDType1Font(Standard14Fonts.FontName.ZAPF_DINGBATS);
            normalAppearanceDict.setItem(COSName.Off, (COSObjectable)CreateCheckBox.createAppearanceStream(document, widget, false, (PDFont)zapfDingbats));
            normalAppearanceDict.setItem(COSName.YES, (COSObjectable)CreateCheckBox.createAppearanceStream(document, widget, true, (PDFont)zapfDingbats));
            page.getAnnotations().add(checkbox.getWidgets().get(0));
            acroForm.getFields().add(checkbox);
            checkbox.unCheck();
            document.save("target/CheckBoxSample.pdf");
        }
    }

    private static PDAppearanceStream createAppearanceStream(PDDocument document, PDAnnotationWidget widget, boolean on, PDFont font) throws IOException {
        PDRectangle rect = widget.getRectangle();
        PDAppearanceStream yesAP = new PDAppearanceStream(document);
        yesAP.setBBox(new PDRectangle(rect.getWidth(), rect.getHeight()));
        yesAP.setResources(new PDResources());
        try (PDAppearanceContentStream yesAPCS = new PDAppearanceContentStream(yesAP);){
            PDAppearanceCharacteristicsDictionary appearanceCharacteristics = widget.getAppearanceCharacteristics();
            PDColor backgroundColor = appearanceCharacteristics.getBackground();
            PDColor borderColor = appearanceCharacteristics.getBorderColour();
            float lineWidth = CreateCheckBox.getLineWidth(widget);
            yesAPCS.setBorderLine(lineWidth, widget.getBorderStyle(), widget.getBorder());
            yesAPCS.setNonStrokingColor(backgroundColor);
            yesAPCS.addRect(0.0f, 0.0f, rect.getWidth(), rect.getHeight());
            yesAPCS.fill();
            yesAPCS.setStrokingColor(borderColor);
            yesAPCS.addRect(lineWidth / 2.0f, lineWidth / 2.0f, rect.getWidth() - lineWidth, rect.getHeight() - lineWidth);
            yesAPCS.stroke();
            if (!on) {
                PDAppearanceStream pDAppearanceStream = yesAP;
                return pDAppearanceStream;
            }
            yesAPCS.addRect(lineWidth, lineWidth, rect.getWidth() - lineWidth * 2.0f, rect.getHeight() - lineWidth * 2.0f);
            yesAPCS.clip();
            String normalCaption = appearanceCharacteristics.getNormalCaption();
            if (normalCaption == null) {
                normalCaption = "4";
            }
            if ("8".equals(normalCaption)) {
                yesAPCS.setStrokingColor(0.0f);
                yesAPCS.moveTo(lineWidth * 2.0f, rect.getHeight() - lineWidth * 2.0f);
                yesAPCS.lineTo(rect.getWidth() - lineWidth * 2.0f, lineWidth * 2.0f);
                yesAPCS.moveTo(rect.getWidth() - lineWidth * 2.0f, rect.getHeight() - lineWidth * 2.0f);
                yesAPCS.lineTo(lineWidth * 2.0f, lineWidth * 2.0f);
                yesAPCS.stroke();
            } else {
                Rectangle2D.Float bounds = new Rectangle2D.Float();
                String unicode = null;
                FontMetrics metric = Standard14Fonts.getAFM((String)Standard14Fonts.FontName.ZAPF_DINGBATS.getName());
                for (CharMetric cm : metric.getCharMetrics()) {
                    if (normalCaption.codePointAt(0) != cm.getCharacterCode()) continue;
                    BoundingBox bb = cm.getBoundingBox();
                    bounds = new Rectangle2D.Float(bb.getLowerLeftX(), bb.getLowerLeftY(), bb.getWidth(), bb.getHeight());
                    unicode = GlyphList.getZapfDingbats().toUnicode(cm.getName());
                    break;
                }
                if (((RectangularShape)bounds).isEmpty()) {
                    throw new IOException("Bounds rectangle for chosen glyph is empty");
                }
                float size = (float)Math.min(((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight()) / 1000.0f;
                float fontSize = (rect.getWidth() - lineWidth * 2.0f) / size * 0.6666f;
                float xOffset = (float)((double)rect.getWidth() - ((RectangularShape)bounds).getWidth() / 1000.0 * (double)fontSize) / 2.0f;
                xOffset = (float)((double)xOffset - ((RectangularShape)bounds).getX() / 1000.0 * (double)fontSize);
                float yOffset = (float)((double)rect.getHeight() - ((RectangularShape)bounds).getHeight() / 1000.0 * (double)fontSize) / 2.0f;
                yOffset = (float)((double)yOffset - ((RectangularShape)bounds).getY() / 1000.0 * (double)fontSize);
                yesAPCS.setNonStrokingColor(0.0f);
                yesAPCS.beginText();
                yesAPCS.setFont(font, fontSize);
                yesAPCS.newLineAtOffset(xOffset, yOffset);
                yesAPCS.showText(unicode);
                yesAPCS.endText();
            }
        }
        return yesAP;
    }

    static float getLineWidth(PDAnnotationWidget widget) {
        PDBorderStyleDictionary bs = widget.getBorderStyle();
        if (bs != null) {
            return bs.getWidth();
        }
        return 1.0f;
    }
}

