/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.util.Hex;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;

public class TSAClient {
    private static final Log LOG = LogFactory.getLog(TSAClient.class);
    private final URL url;
    private final String username;
    private final String password;
    private final MessageDigest digest;
    private static final Random RANDOM = new SecureRandom();

    public TSAClient(URL url, String username, String password, MessageDigest digest) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.digest = digest;
    }

    public TimeStampToken getTimeStampToken(byte[] content) throws IOException {
        this.digest.reset();
        byte[] hash = this.digest.digest(content);
        int nonce = RANDOM.nextInt(Integer.MAX_VALUE);
        TimeStampRequestGenerator tsaGenerator = new TimeStampRequestGenerator();
        tsaGenerator.setCertReq(true);
        ASN1ObjectIdentifier oid = this.getHashObjectIdentifier(this.digest.getAlgorithm());
        TimeStampRequest request = tsaGenerator.generate(oid, hash, BigInteger.valueOf(nonce));
        byte[] encodedRequest = request.getEncoded();
        byte[] tsaResponse = this.getTSAResponse(encodedRequest);
        TimeStampResponse response = null;
        try {
            response = new TimeStampResponse(tsaResponse);
            response.validate(request);
        }
        catch (TSPException e) {
            LOG.error((Object)("request: " + Hex.getString((byte[])encodedRequest)));
            if (response != null) {
                LOG.error((Object)("response: " + Hex.getString((byte[])tsaResponse)));
                if ("response contains wrong nonce value.".equals(e.getMessage())) {
                    TimeStampTokenInfo tsi;
                    LOG.error((Object)("request nonce: " + request.getNonce().toString(16)));
                    if (response.getTimeStampToken() != null && (tsi = response.getTimeStampToken().getTimeStampInfo()) != null && tsi.getNonce() != null) {
                        LOG.error((Object)("response nonce: " + tsi.getNonce().toString(16)));
                    }
                }
            }
            throw new IOException(e);
        }
        TimeStampToken timeStampToken = response.getTimeStampToken();
        if (timeStampToken == null) {
            throw new IOException("Response from " + this.url + " does not have a time stamp token, status: " + response.getStatus() + " (" + response.getStatusString() + ")");
        }
        return timeStampToken;
    }

    private byte[] getTSAResponse(byte[] request) throws IOException {
        byte[] response;
        LOG.debug((Object)"Opening connection to TSA server");
        URLConnection connection = this.url.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-Type", "application/timestamp-query");
        LOG.debug((Object)"Established connection to TSA server");
        if (this.username != null && this.password != null && !this.username.isEmpty() && !this.password.isEmpty()) {
            throw new UnsupportedOperationException("authentication not implemented yet");
        }
        OutputStream output = null;
        try {
            output = connection.getOutputStream();
            output.write(request);
        }
        catch (IOException ex) {
            LOG.error((Object)("Exception when writing to " + this.url), (Throwable)ex);
            throw ex;
        }
        finally {
            IOUtils.closeQuietly((Closeable)output);
        }
        LOG.debug((Object)"Waiting for response from TSA server");
        InputStream input = null;
        try {
            input = connection.getInputStream();
            response = IOUtils.toByteArray((InputStream)input);
        }
        catch (IOException ex) {
            LOG.error((Object)("Exception when reading from " + this.url), (Throwable)ex);
            throw ex;
        }
        finally {
            IOUtils.closeQuietly((Closeable)input);
        }
        LOG.debug((Object)"Received response from TSA server");
        return response;
    }

    private ASN1ObjectIdentifier getHashObjectIdentifier(String algorithm) {
        if (algorithm.equals("MD2")) {
            return new ASN1ObjectIdentifier(PKCSObjectIdentifiers.md2.getId());
        }
        if (algorithm.equals("MD5")) {
            return new ASN1ObjectIdentifier(PKCSObjectIdentifiers.md5.getId());
        }
        if (algorithm.equals("SHA-1")) {
            return new ASN1ObjectIdentifier(OIWObjectIdentifiers.idSHA1.getId());
        }
        if (algorithm.equals("SHA-224")) {
            return new ASN1ObjectIdentifier(NISTObjectIdentifiers.id_sha224.getId());
        }
        if (algorithm.equals("SHA-256")) {
            return new ASN1ObjectIdentifier(NISTObjectIdentifiers.id_sha256.getId());
        }
        if (algorithm.equals("SHA-384")) {
            return new ASN1ObjectIdentifier(NISTObjectIdentifiers.id_sha384.getId());
        }
        if (algorithm.equals("SHA-512")) {
            return new ASN1ObjectIdentifier(NISTObjectIdentifiers.id_sha512.getId());
        }
        return new ASN1ObjectIdentifier(algorithm);
    }
}

