/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.encoding.Encoding;
import org.apache.pdfbox.pdmodel.font.encoding.WinAnsiEncoding;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.StringUtil;

public class ShowTextWithPositioning {
    private static final float FONT_SIZE = 20.0f;

    private ShowTextWithPositioning() {
    }

    public static void main(String[] args) throws IOException {
        ShowTextWithPositioning.doIt("Hello World, this is a test!", "justify-example.pdf");
    }

    public static void doIt(String message, String outfile) throws IOException {
        PDDocument doc = new PDDocument();
        InputStream is = PDDocument.class.getResourceAsStream("/org/apache/pdfbox/resources/ttf/LiberationSans-Regular.ttf");
        PDType0Font font = PDType0Font.load((PDDocument)doc, (InputStream)is, (boolean)true);
        PDPage page = new PDPage(PDRectangle.A4);
        doc.addPage(page);
        float stringWidth = font.getStringWidth(message) * 20.0f;
        float stringHeight = font.getFontDescriptor().getFontBoundingBox().getHeight() * 20.0f;
        PDRectangle pageSize = page.getMediaBox();
        PDPageContentStream contentStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.OVERWRITE, false);
        contentStream.beginText();
        contentStream.setFont((PDFont)font, 20.0f);
        contentStream.setTextMatrix(Matrix.getTranslateInstance((float)0.0f, (float)(pageSize.getHeight() - stringHeight / 1000.0f)));
        contentStream.showText(message);
        contentStream.setTextMatrix(Matrix.getTranslateInstance((float)0.0f, (float)(pageSize.getHeight() - stringHeight / 1000.0f * 2.0f)));
        float justifyWidth = pageSize.getWidth() * 1000.0f - stringWidth;
        ArrayList<Object> text = new ArrayList<Object>();
        String[] parts = StringUtil.splitOnSpace((String)message);
        float spaceWidth = justifyWidth / (float)(parts.length - 1) / 20.0f;
        for (int i = 0; i < parts.length; ++i) {
            if (i != 0) {
                text.add(" ");
                text.add(Float.valueOf(-spaceWidth));
            }
            text.add(parts[i]);
        }
        contentStream.showTextWithPositioning(text.toArray());
        contentStream.setTextMatrix(Matrix.getTranslateInstance((float)0.0f, (float)(pageSize.getHeight() - stringHeight / 1000.0f * 3.0f)));
        text = new ArrayList();
        justifyWidth = pageSize.getWidth() * 1000.0f - stringWidth;
        float extraLetterWidth = justifyWidth / (float)(message.codePointCount(0, message.length()) - 1) / 20.0f;
        for (int i = 0; i < message.length(); i += Character.charCount(message.codePointAt(i))) {
            if (i != 0) {
                text.add(Float.valueOf(-extraLetterWidth));
            }
            text.add(String.valueOf(Character.toChars(message.codePointAt(i))));
        }
        contentStream.showTextWithPositioning(text.toArray());
        contentStream.setTextMatrix(Matrix.getTranslateInstance((float)0.0f, (float)(pageSize.getHeight() - stringHeight / 1000.0f * 4.0f)));
        font = PDTrueTypeFont.load((PDDocument)doc, (InputStream)PDDocument.class.getResourceAsStream("/org/apache/pdfbox/resources/ttf/LiberationSans-Regular.ttf"), (Encoding)WinAnsiEncoding.INSTANCE);
        contentStream.setFont((PDFont)font, 20.0f);
        contentStream.showText(message);
        float wordSpacing = (pageSize.getWidth() * 1000.0f - stringWidth) / (float)(parts.length - 1) / 1000.0f;
        contentStream.setTextMatrix(Matrix.getTranslateInstance((float)0.0f, (float)(pageSize.getHeight() - stringHeight / 1000.0f * 5.0f)));
        font = PDTrueTypeFont.load((PDDocument)doc, (InputStream)PDDocument.class.getResourceAsStream("/org/apache/pdfbox/resources/ttf/LiberationSans-Regular.ttf"), (Encoding)WinAnsiEncoding.INSTANCE);
        contentStream.setFont((PDFont)font, 20.0f);
        contentStream.setWordSpacing(wordSpacing);
        contentStream.showText(message);
        contentStream.setTextMatrix(Matrix.getTranslateInstance((float)0.0f, (float)(pageSize.getHeight() - stringHeight / 1000.0f * 6.0f)));
        font = PDType0Font.load((PDDocument)doc, (InputStream)PDDocument.class.getResourceAsStream("/org/apache/pdfbox/resources/ttf/LiberationSans-Regular.ttf"));
        contentStream.setFont((PDFont)font, 20.0f);
        contentStream.setWordSpacing(wordSpacing);
        contentStream.showText(message);
        contentStream.endText();
        contentStream.close();
        doc.save(outfile);
        doc.close();
    }
}

