/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature.validation;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSUpdateInfo;
import org.apache.pdfbox.examples.signature.SigUtils;
import org.apache.pdfbox.examples.signature.cert.CRLVerifier;
import org.apache.pdfbox.examples.signature.cert.CertificateVerificationException;
import org.apache.pdfbox.examples.signature.cert.OcspHelper;
import org.apache.pdfbox.examples.signature.cert.RevokedCertificateException;
import org.apache.pdfbox.examples.signature.validation.CertInformationCollector;
import org.apache.pdfbox.examples.signature.validation.CertificateProccessingException;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.encryption.SecurityProvider;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.util.Hex;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;

public class AddValidationInformation {
    private static final Log LOG = LogFactory.getLog(AddValidationInformation.class);
    private CertInformationCollector certInformationHelper;
    private COSArray correspondingOCSPs;
    private COSArray correspondingCRLs;
    private COSDictionary vriBase;
    private COSArray ocsps;
    private COSArray crls;
    private COSArray certs;
    private final Map<X509Certificate, COSStream> certMap = new HashMap<X509Certificate, COSStream>();
    private PDDocument document;
    private final Set<X509Certificate> foundRevocationInformation = new HashSet<X509Certificate>();
    private Calendar signDate;
    private final Set<X509Certificate> ocspChecked = new HashSet<X509Certificate>();

    public void validateSignature(File inFile, File outFile) throws IOException {
        if (inFile == null || !inFile.exists()) {
            String err = "Document for signing ";
            err = null == inFile ? err + "is null" : err + "does not exist: " + inFile.getAbsolutePath();
            throw new FileNotFoundException(err);
        }
        PDDocument doc = PDDocument.load((File)inFile);
        FileOutputStream fos = new FileOutputStream(outFile);
        int accessPermissions = SigUtils.getMDPPermission(doc);
        if (accessPermissions == 1) {
            System.out.println("PDF is certified to forbid changes, some readers may report the document as invalid despite that the PDF specification allows DSS additions");
        }
        this.document = doc;
        this.doValidation(inFile.getAbsolutePath(), fos);
        fos.close();
        doc.close();
    }

    private void doValidation(String filename, OutputStream output) throws IOException {
        this.certInformationHelper = new CertInformationCollector();
        CertInformationCollector.CertSignatureInformation certInfo = null;
        try {
            PDSignature signature = SigUtils.getLastRelevantSignature(this.document);
            if (signature != null) {
                certInfo = this.certInformationHelper.getLastCertInfo(signature, filename);
                this.signDate = signature.getSignDate();
                if ("ETSI.RFC3161".equals(signature.getSubFilter())) {
                    byte[] contents = signature.getContents();
                    TimeStampToken timeStampToken = new TimeStampToken(new CMSSignedData(contents));
                    TimeStampTokenInfo timeStampInfo = timeStampToken.getTimeStampInfo();
                    this.signDate = Calendar.getInstance();
                    this.signDate.setTime(timeStampInfo.getGenTime());
                }
            }
        }
        catch (CertificateProccessingException e) {
            throw new IOException("An Error occurred processing the Signature", e);
        }
        catch (CMSException e) {
            throw new IOException("An Error occurred processing the Signature", e);
        }
        catch (TSPException e) {
            throw new IOException("An Error occurred processing the Signature", e);
        }
        if (certInfo == null) {
            throw new IOException("No Certificate information or signature found in the given document");
        }
        PDDocumentCatalog docCatalog = this.document.getDocumentCatalog();
        COSDictionary catalog = docCatalog.getCOSObject();
        catalog.setNeedToBeUpdated(true);
        COSDictionary dss = AddValidationInformation.getOrCreateDictionaryEntry(COSDictionary.class, catalog, "DSS");
        this.addExtensions(docCatalog);
        this.vriBase = AddValidationInformation.getOrCreateDictionaryEntry(COSDictionary.class, dss, "VRI");
        this.ocsps = AddValidationInformation.getOrCreateDictionaryEntry(COSArray.class, dss, "OCSPs");
        this.crls = AddValidationInformation.getOrCreateDictionaryEntry(COSArray.class, dss, "CRLs");
        this.certs = AddValidationInformation.getOrCreateDictionaryEntry(COSArray.class, dss, "Certs");
        this.addRevocationData(certInfo);
        this.addAllCertsToCertArray();
        this.document.saveIncremental(output);
    }

    private static <T extends COSBase> T getOrCreateDictionaryEntry(Class<T> clazz, COSDictionary parent, String name) throws IOException {
        COSBase result;
        COSBase element = parent.getDictionaryObject(name);
        if (element != null && clazz.isInstance(element)) {
            result = (COSBase)clazz.cast(element);
            ((COSUpdateInfo)result).setNeedToBeUpdated(true);
        } else {
            if (element != null) {
                throw new IOException("Element " + name + " from dictionary is not of type " + clazz.getCanonicalName());
            }
            try {
                result = (COSBase)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException ex) {
                throw new IOException("Failed to create new instance of " + clazz.getCanonicalName(), ex);
            }
            catch (IllegalAccessException ex) {
                throw new IOException("Failed to create new instance of " + clazz.getCanonicalName(), ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IOException("Failed to create new instance of " + clazz.getCanonicalName(), ex);
            }
            catch (SecurityException ex) {
                throw new IOException("Failed to create new instance of " + clazz.getCanonicalName(), ex);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException("Failed to create new instance of " + clazz.getCanonicalName(), ex);
            }
            catch (InvocationTargetException ex) {
                throw new IOException("Failed to create new instance of " + clazz.getCanonicalName(), ex);
            }
            result.setDirect(false);
            parent.setItem(COSName.getPDFName((String)name), result);
        }
        return (T)result;
    }

    private void addRevocationData(CertInformationCollector.CertSignatureInformation certInfo) throws IOException {
        COSDictionary vri = new COSDictionary();
        this.vriBase.setItem(certInfo.getSignatureHash(), (COSBase)vri);
        this.updateVRI(certInfo, vri);
        if (certInfo.getTsaCerts() != null) {
            this.correspondingOCSPs = null;
            this.correspondingCRLs = null;
            this.addRevocationDataRecursive(certInfo.getTsaCerts());
        }
    }

    private void addRevocationDataRecursive(CertInformationCollector.CertSignatureInformation certInfo) throws IOException {
        if (certInfo.isSelfSigned()) {
            return;
        }
        boolean isRevocationInfoFound = this.foundRevocationInformation.contains(certInfo.getCertificate());
        if (!isRevocationInfoFound) {
            if (certInfo.getOcspUrl() != null && certInfo.getIssuerCertificate() != null) {
                isRevocationInfoFound = this.fetchOcspData(certInfo);
            }
            if (!isRevocationInfoFound && certInfo.getCrlUrl() != null) {
                this.fetchCrlData(certInfo);
                isRevocationInfoFound = true;
            }
            if (certInfo.getOcspUrl() == null && certInfo.getCrlUrl() == null) {
                LOG.info((Object)("No revocation information for cert " + certInfo.getCertificate().getSubjectX500Principal()));
            } else if (!isRevocationInfoFound) {
                throw new IOException("Could not fetch Revocation Info for Cert: " + certInfo.getCertificate().getSubjectX500Principal());
            }
        }
        if (certInfo.getAlternativeCertChain() != null) {
            this.addRevocationDataRecursive(certInfo.getAlternativeCertChain());
        }
        if (certInfo.getCertChain() != null && certInfo.getCertChain().getCertificate() != null) {
            this.addRevocationDataRecursive(certInfo.getCertChain());
        }
    }

    private boolean fetchOcspData(CertInformationCollector.CertSignatureInformation certInfo) throws IOException {
        try {
            this.addOcspData(certInfo);
            return true;
        }
        catch (OCSPException e) {
            LOG.error((Object)("Failed fetching OCSP at " + certInfo.getOcspUrl()), (Throwable)e);
            return false;
        }
        catch (CertificateProccessingException e) {
            LOG.error((Object)("Failed fetching OCSP at " + certInfo.getOcspUrl()), (Throwable)e);
            return false;
        }
        catch (IOException e) {
            LOG.error((Object)("Failed fetching OCSP at " + certInfo.getOcspUrl()), (Throwable)e);
            return false;
        }
        catch (RevokedCertificateException e) {
            throw new IOException(e);
        }
    }

    private void fetchCrlData(CertInformationCollector.CertSignatureInformation certInfo) throws IOException {
        try {
            this.addCrlRevocationInfo(certInfo);
        }
        catch (GeneralSecurityException e) {
            LOG.warn((Object)"Failed fetching CRL", (Throwable)e);
            throw new IOException(e);
        }
        catch (RevokedCertificateException e) {
            LOG.warn((Object)"Failed fetching CRL", (Throwable)e);
            throw new IOException(e);
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed fetching CRL", (Throwable)e);
            throw new IOException(e);
        }
        catch (CertificateVerificationException e) {
            LOG.warn((Object)"Failed fetching CRL", (Throwable)e);
            throw new IOException(e);
        }
    }

    private void addOcspData(CertInformationCollector.CertSignatureInformation certInfo) throws IOException, OCSPException, CertificateProccessingException, RevokedCertificateException {
        byte[] signatureHash;
        if (this.ocspChecked.contains(certInfo.getCertificate())) {
            return;
        }
        OcspHelper ocspHelper = new OcspHelper(certInfo.getCertificate(), this.signDate.getTime(), certInfo.getIssuerCertificate(), new HashSet<X509Certificate>(this.certInformationHelper.getCertificateSet()), certInfo.getOcspUrl());
        OCSPResp ocspResp = ocspHelper.getResponseOcsp();
        this.ocspChecked.add(certInfo.getCertificate());
        BasicOCSPResp basicResponse = (BasicOCSPResp)ocspResp.getResponseObject();
        X509Certificate ocspResponderCertificate = ocspHelper.getOcspResponderCertificate();
        this.certInformationHelper.addAllCertsFromHolders(basicResponse.getCerts());
        try {
            BEROctetString encodedSignature = new BEROctetString(basicResponse.getSignature());
            signatureHash = MessageDigest.getInstance("SHA-1").digest(encodedSignature.getEncoded());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CertificateProccessingException(ex);
        }
        String signatureHashHex = Hex.getString((byte[])signatureHash);
        if (!this.vriBase.containsKey(signatureHashHex)) {
            COSArray savedCorrespondingOCSPs = this.correspondingOCSPs;
            COSArray savedCorrespondingCRLs = this.correspondingCRLs;
            COSDictionary vri = new COSDictionary();
            this.vriBase.setItem(signatureHashHex, (COSBase)vri);
            CertInformationCollector.CertSignatureInformation ocspCertInfo = this.certInformationHelper.getCertInfo(ocspResponderCertificate);
            this.updateVRI(ocspCertInfo, vri);
            this.correspondingOCSPs = savedCorrespondingOCSPs;
            this.correspondingCRLs = savedCorrespondingCRLs;
        }
        byte[] ocspData = ocspResp.getEncoded();
        COSStream ocspStream = this.writeDataToStream(ocspData);
        this.ocsps.add((COSBase)ocspStream);
        if (this.correspondingOCSPs != null) {
            this.correspondingOCSPs.add((COSBase)ocspStream);
        }
        this.foundRevocationInformation.add(certInfo.getCertificate());
    }

    private void addCrlRevocationInfo(CertInformationCollector.CertSignatureInformation certInfo) throws IOException, RevokedCertificateException, GeneralSecurityException, CertificateVerificationException {
        X509CRL crl = CRLVerifier.downloadCRLFromWeb(certInfo.getCrlUrl());
        X509Certificate issuerCertificate = certInfo.getIssuerCertificate();
        for (X509Certificate certificate : this.certInformationHelper.getCertificateSet()) {
            if (!certificate.getSubjectX500Principal().equals(crl.getIssuerX500Principal())) continue;
            issuerCertificate = certificate;
            break;
        }
        crl.verify(issuerCertificate.getPublicKey(), SecurityProvider.getProvider().getName());
        CRLVerifier.checkRevocation(crl, certInfo.getCertificate(), this.signDate.getTime(), certInfo.getCrlUrl());
        COSStream crlStream = this.writeDataToStream(crl.getEncoded());
        this.crls.add((COSBase)crlStream);
        if (this.correspondingCRLs != null) {
            byte[] signatureHash;
            this.correspondingCRLs.add((COSBase)crlStream);
            try {
                BEROctetString berEncodedSignature = new BEROctetString(crl.getSignature());
                signatureHash = MessageDigest.getInstance("SHA-1").digest(berEncodedSignature.getEncoded());
            }
            catch (NoSuchAlgorithmException ex) {
                throw new CertificateVerificationException(ex.getMessage(), ex);
            }
            String signatureHashHex = Hex.getString((byte[])signatureHash);
            if (!this.vriBase.containsKey(signatureHashHex)) {
                CertInformationCollector.CertSignatureInformation crlCertInfo;
                COSArray savedCorrespondingOCSPs = this.correspondingOCSPs;
                COSArray savedCorrespondingCRLs = this.correspondingCRLs;
                COSDictionary vri = new COSDictionary();
                this.vriBase.setItem(signatureHashHex, (COSBase)vri);
                try {
                    crlCertInfo = this.certInformationHelper.getCertInfo(issuerCertificate);
                }
                catch (CertificateProccessingException ex) {
                    throw new CertificateVerificationException(ex.getMessage(), ex);
                }
                this.updateVRI(crlCertInfo, vri);
                this.correspondingOCSPs = savedCorrespondingOCSPs;
                this.correspondingCRLs = savedCorrespondingCRLs;
            }
        }
        this.foundRevocationInformation.add(certInfo.getCertificate());
    }

    private void updateVRI(CertInformationCollector.CertSignatureInformation certInfo, COSDictionary vri) throws IOException {
        X509Certificate cert;
        if (certInfo.getCertificate().getExtensionValue(OCSPObjectIdentifiers.id_pkix_ocsp_nocheck.getId()) == null) {
            this.correspondingOCSPs = new COSArray();
            this.correspondingCRLs = new COSArray();
            this.addRevocationDataRecursive(certInfo);
            if (this.correspondingOCSPs.size() > 0) {
                vri.setItem("OCSP", (COSBase)this.correspondingOCSPs);
            }
            if (this.correspondingCRLs.size() > 0) {
                vri.setItem("CRL", (COSBase)this.correspondingCRLs);
            }
        }
        COSArray correspondingCerts = new COSArray();
        CertInformationCollector.CertSignatureInformation ci = certInfo;
        do {
            cert = ci.getCertificate();
            try {
                COSStream certStream = this.writeDataToStream(cert.getEncoded());
                correspondingCerts.add((COSBase)certStream);
                this.certMap.put(cert, certStream);
            }
            catch (CertificateEncodingException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        } while (cert.getExtensionValue(OCSPObjectIdentifiers.id_pkix_ocsp_nocheck.getId()) == null && (ci = ci.getCertChain()) != null);
        vri.setItem(COSName.CERT, (COSBase)correspondingCerts);
        vri.setDate(COSName.TU, Calendar.getInstance());
    }

    private void addAllCertsToCertArray() throws IOException {
        for (X509Certificate cert : this.certInformationHelper.getCertificateSet()) {
            if (this.certMap.containsKey(cert)) continue;
            try {
                COSStream certStream = this.writeDataToStream(cert.getEncoded());
                this.certMap.put(cert, certStream);
            }
            catch (CertificateEncodingException ex) {
                throw new IOException(ex);
            }
        }
        for (COSStream certStream : this.certMap.values()) {
            this.certs.add((COSBase)certStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private COSStream writeDataToStream(byte[] data) throws IOException {
        COSStream stream = this.document.getDocument().createCOSStream();
        OutputStream os = null;
        try {
            os = stream.createOutputStream((COSBase)COSName.FLATE_DECODE);
            os.write(data);
        }
        finally {
            IOUtils.closeQuietly((Closeable)os);
        }
        return stream;
    }

    private void addExtensions(PDDocumentCatalog catalog) {
        COSDictionary dssExtensions = new COSDictionary();
        dssExtensions.setDirect(true);
        catalog.getCOSObject().setItem("Extensions", (COSBase)dssExtensions);
        COSDictionary adbeExtension = new COSDictionary();
        adbeExtension.setDirect(true);
        dssExtensions.setItem("ADBE", (COSBase)adbeExtension);
        adbeExtension.setName("BaseVersion", "1.7");
        adbeExtension.setInt("ExtensionLevel", 5);
        catalog.setVersion("1.7");
    }

    public static void main(String[] args) throws IOException, GeneralSecurityException {
        if (args.length != 1) {
            AddValidationInformation.usage();
            System.exit(1);
        }
        Security.addProvider(SecurityProvider.getProvider());
        AddValidationInformation addOcspInformation = new AddValidationInformation();
        File inFile = new File(args[0]);
        String name = inFile.getName();
        String substring = name.substring(0, name.lastIndexOf(46));
        File outFile = new File(inFile.getParent(), substring + "_LTV.pdf");
        addOcspInformation.validateSignature(inFile, outFile);
    }

    private static void usage() {
        System.err.println("usage: java " + AddValidationInformation.class.getName() + " <pdf_to_add_ocsp>\n");
    }
}

