/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;

public final class ExtractTTFFonts {
    private int fontCounter = 1;
    private static final String PASSWORD = "-password";
    private static final String PREFIX = "-prefix";
    private static final String ADDKEY = "-addkey";

    private ExtractTTFFonts() {
    }

    public static void main(String[] args) throws IOException {
        ExtractTTFFonts extractor = new ExtractTTFFonts();
        extractor.extractFonts(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFonts(String[] args) throws IOException {
        if (args.length < 1 || args.length > 4) {
            ExtractTTFFonts.usage();
        } else {
            String pdfFile = null;
            String password = "";
            String prefix = null;
            boolean addKey = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals(PASSWORD)) {
                    if (++i >= args.length) {
                        ExtractTTFFonts.usage();
                    }
                    password = args[i];
                    continue;
                }
                if (args[i].equals(PREFIX)) {
                    if (++i >= args.length) {
                        ExtractTTFFonts.usage();
                    }
                    prefix = args[i];
                    continue;
                }
                if (args[i].equals(ADDKEY)) {
                    addKey = true;
                    continue;
                }
                if (pdfFile != null) continue;
                pdfFile = args[i];
            }
            if (pdfFile == null) {
                ExtractTTFFonts.usage();
            } else {
                if (prefix == null && pdfFile.length() > 4) {
                    prefix = pdfFile.substring(0, pdfFile.length() - 4);
                }
                PDDocument document = null;
                try {
                    document = PDDocument.load((File)new File(pdfFile), (String)password);
                    for (PDPage page : document.getPages()) {
                        PDResources resources = page.getResources();
                        this.processResources(resources, prefix, addKey);
                    }
                }
                finally {
                    if (document != null) {
                        document.close();
                    }
                }
            }
        }
    }

    private void processResources(PDResources resources, String prefix, boolean addKey) throws IOException {
        if (resources == null) {
            return;
        }
        for (COSName key : resources.getFontNames()) {
            PDCIDFont descendantFont;
            PDFont font = resources.getFont(key);
            if (font instanceof PDTrueTypeFont) {
                String name = null;
                name = addKey ? this.getUniqueFileName(prefix + "_" + key, "ttf") : this.getUniqueFileName(prefix, "ttf");
                this.writeFont(font.getFontDescriptor(), name);
                continue;
            }
            if (!(font instanceof PDType0Font) || !((descendantFont = ((PDType0Font)font).getDescendantFont()) instanceof PDCIDFontType2)) continue;
            String name = null;
            name = addKey ? this.getUniqueFileName(prefix + "_" + key, "ttf") : this.getUniqueFileName(prefix, "ttf");
            this.writeFont(descendantFont.getFontDescriptor(), name);
        }
        for (COSName name : resources.getXObjectNames()) {
            PDXObject xobject = resources.getXObject(name);
            if (!(xobject instanceof PDFormXObject)) continue;
            PDFormXObject xObjectForm = (PDFormXObject)xobject;
            PDResources formResources = xObjectForm.getResources();
            this.processResources(formResources, prefix, addKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFont(PDFontDescriptor fd, String name) throws IOException {
        PDStream ff2Stream;
        if (fd != null && (ff2Stream = fd.getFontFile2()) != null) {
            FileOutputStream fos = null;
            try {
                System.out.println("Writing font:" + name);
                fos = new FileOutputStream(new File(name + ".ttf"));
                IOUtils.copy((InputStream)ff2Stream.createInputStream(), (OutputStream)fos);
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }
    }

    private String getUniqueFileName(String prefix, String suffix) {
        String uniqueName = null;
        File f = null;
        while (f == null || f.exists()) {
            uniqueName = prefix + "-" + this.fontCounter;
            f = new File(uniqueName + "." + suffix);
            ++this.fontCounter;
        }
        return uniqueName;
    }

    private static void usage() {
        System.err.println("Usage: java " + ExtractTTFFonts.class.getName() + " [OPTIONS] <PDF file>\n  -password  <password>        Password to decrypt document\n  -prefix  <font-prefix>       Font prefix(default to pdf name)\n  -addkey                      add the internal font key to the file name\n  <PDF file>                   The PDF document to use\n");
        System.exit(1);
    }
}

