/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.ui;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;

public class XrefEntry {
    private final int index;
    private final COSObjectKey key;
    private final long offset;
    private final COSObject cosObject;

    public XrefEntry(int index, COSObjectKey key, long offset, COSObject cosObject) {
        this.index = index;
        this.key = key;
        this.offset = offset;
        this.cosObject = cosObject;
    }

    public COSObjectKey getKey() {
        return this.key;
    }

    public int getIndex() {
        return this.index;
    }

    public COSObject getCOSObject() {
        return this.cosObject;
    }

    public COSBase getObject() {
        return this.cosObject != null ? this.cosObject.getObject() : null;
    }

    public String getPath() {
        return "CRT/" + this.toString();
    }

    public String toString() {
        if (this.key == null) {
            return "(null)";
        }
        return this.offset >= 0L ? "Offset: " + this.offset + " [" + this.key.toString() + "]" : "Compressed object stream: " + -this.offset + " [" + this.key.toString() + "]";
    }
}

