/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.flagbitspane;

import javax.swing.JPanel;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.debugger.flagbitspane.AnnotFlag;
import org.apache.pdfbox.debugger.flagbitspane.EncryptFlag;
import org.apache.pdfbox.debugger.flagbitspane.FieldFlag;
import org.apache.pdfbox.debugger.flagbitspane.Flag;
import org.apache.pdfbox.debugger.flagbitspane.FlagBitsPaneView;
import org.apache.pdfbox.debugger.flagbitspane.FontFlag;
import org.apache.pdfbox.debugger.flagbitspane.PanoseFlag;
import org.apache.pdfbox.debugger.flagbitspane.SigFlag;

public class FlagBitsPane {
    private FlagBitsPaneView view;

    public FlagBitsPane(COSDictionary dictionary, COSName flagType) {
        this.createPane(dictionary, flagType);
    }

    private void createPane(COSDictionary dictionary, COSName flagType) {
        Flag flag;
        if (COSName.FLAGS.equals((Object)flagType)) {
            flag = new FontFlag(dictionary);
            this.view = new FlagBitsPaneView(flag.getFlagType(), flag.getFlagValue(), flag.getFlagBits(), flag.getColumnNames());
        }
        if (COSName.F.equals((Object)flagType)) {
            flag = new AnnotFlag(dictionary);
            this.view = new FlagBitsPaneView(flag.getFlagType(), flag.getFlagValue(), flag.getFlagBits(), flag.getColumnNames());
        }
        if (COSName.FF.equals((Object)flagType)) {
            flag = new FieldFlag(dictionary);
            this.view = new FlagBitsPaneView(flag.getFlagType(), flag.getFlagValue(), flag.getFlagBits(), flag.getColumnNames());
        }
        if (COSName.PANOSE.equals((Object)flagType)) {
            flag = new PanoseFlag(dictionary);
            this.view = new FlagBitsPaneView(flag.getFlagType(), flag.getFlagValue(), flag.getFlagBits(), flag.getColumnNames());
        }
        if (COSName.P.equals((Object)flagType)) {
            flag = new EncryptFlag(dictionary);
            this.view = new FlagBitsPaneView(flag.getFlagType(), flag.getFlagValue(), flag.getFlagBits(), flag.getColumnNames());
        }
        if (COSName.SIG_FLAGS.equals((Object)flagType)) {
            flag = new SigFlag(dictionary);
            this.view = new FlagBitsPaneView(flag.getFlagType(), flag.getFlagValue(), flag.getFlagBits(), flag.getColumnNames());
        }
    }

    public JPanel getPane() {
        return this.view.getPanel();
    }
}

