/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfwriter.compress;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfwriter.COSWriter;
import org.apache.pdfbox.pdfwriter.compress.COSWriterCompressionPool;

public class COSWriterObjectStream {
    private static final Log LOG = LogFactory.getLog(COSWriterObjectStream.class);
    private final COSWriterCompressionPool compressionPool;
    private final List<COSObjectKey> preparedKeys = new ArrayList<COSObjectKey>();
    private final List<COSBase> preparedObjects = new ArrayList<COSBase>();

    public COSWriterObjectStream(COSWriterCompressionPool compressionPool) {
        this.compressionPool = compressionPool;
    }

    public void prepareStreamObject(COSObjectKey key, COSBase object) {
        if (key != null && object != null) {
            this.preparedKeys.add(key);
            this.preparedObjects.add(object instanceof COSObject ? ((COSObject)object).getObject() : object);
        }
    }

    public List<COSObjectKey> getPreparedKeys() {
        return Collections.unmodifiableList(this.preparedKeys);
    }

    public COSStream writeObjectsToStream(COSStream stream) throws IOException {
        byte[] offsetsMapBuffer;
        int objectCount = this.preparedKeys.size();
        stream.setItem(COSName.TYPE, (COSBase)COSName.OBJ_STM);
        stream.setInt(COSName.N, objectCount);
        ArrayList<Long> objectNumbers = new ArrayList<Long>(objectCount);
        ArrayList<byte[]> objectsBuffer = new ArrayList<byte[]>(objectCount);
        for (int i = 0; i < objectCount; ++i) {
            try (ByteArrayOutputStream partialOutput = new ByteArrayOutputStream();){
                objectNumbers.add(this.preparedKeys.get(i).getNumber());
                COSBase base = this.preparedObjects.get(i);
                this.writeObject(partialOutput, base, true);
                objectsBuffer.add(partialOutput.toByteArray());
                continue;
            }
        }
        long nextObjectOffset = 0L;
        try (ByteArrayOutputStream partialOutput = new ByteArrayOutputStream();){
            for (int i = 0; i < objectNumbers.size(); ++i) {
                partialOutput.write(String.valueOf(objectNumbers.get(i)).getBytes(StandardCharsets.ISO_8859_1));
                partialOutput.write(COSWriter.SPACE);
                partialOutput.write(String.valueOf(nextObjectOffset).getBytes(StandardCharsets.ISO_8859_1));
                partialOutput.write(COSWriter.SPACE);
                nextObjectOffset += (long)((byte[])objectsBuffer.get(i)).length;
            }
            offsetsMapBuffer = partialOutput.toByteArray();
        }
        var9_14 = null;
        try (OutputStream output = stream.createOutputStream(COSName.FLATE_DECODE);){
            output.write(offsetsMapBuffer);
            stream.setInt(COSName.FIRST, offsetsMapBuffer.length);
            for (byte[] rawObject : objectsBuffer) {
                output.write(rawObject);
            }
        }
        catch (Throwable throwable) {
            var9_14 = throwable;
            throw throwable;
        }
        return stream;
    }

    private void writeObject(OutputStream output, COSBase object, boolean topLevel) throws IOException {
        COSBase base;
        if (object == null) {
            return;
        }
        if (!(object instanceof COSBase)) {
            throw new IOException("Error: Unknown type in object stream:" + object);
        }
        if (object instanceof COSObject) {
            COSObjectKey actualKey;
            if (!topLevel && (actualKey = ((COSObject)object).getKey()) != null) {
                this.writeObjectReference(output, actualKey);
                return;
            }
            base = ((COSObject)object).getObject();
            if (base == null) {
                LOG.debug("Can't dereference indirect object, writing COSNull instead " + object);
                this.writeCOSNull(output);
                return;
            }
        } else {
            base = object;
        }
        if (!topLevel && this.compressionPool.contains(base)) {
            COSObjectKey key = this.compressionPool.getKey(base);
            if (key == null) {
                throw new IOException("Error: Adding unknown object reference to object stream:" + object);
            }
            this.writeObjectReference(output, key);
            return;
        }
        if (base instanceof COSString) {
            this.writeCOSString(output, (COSString)base);
        } else if (base instanceof COSFloat) {
            this.writeCOSFloat(output, (COSFloat)base);
        } else if (base instanceof COSInteger) {
            this.writeCOSInteger(output, (COSInteger)base);
        } else if (base instanceof COSBoolean) {
            this.writeCOSBoolean(output, (COSBoolean)base);
        } else if (base instanceof COSName) {
            this.writeCOSName(output, (COSName)base);
        } else if (base instanceof COSArray) {
            this.writeCOSArray(output, (COSArray)base);
        } else if (base instanceof COSDictionary) {
            this.writeCOSDictionary(output, (COSDictionary)base);
        } else if (base instanceof COSNull) {
            this.writeCOSNull(output);
        } else {
            throw new IOException("Error: Unknown type in object stream:" + object);
        }
    }

    private void writeCOSString(OutputStream output, COSString cosString) throws IOException {
        COSWriter.writeString(cosString, output);
        output.write(COSWriter.SPACE);
    }

    private void writeCOSFloat(OutputStream output, COSFloat cosFloat) throws IOException {
        cosFloat.writePDF(output);
        output.write(COSWriter.SPACE);
    }

    private void writeCOSInteger(OutputStream output, COSInteger cosInteger) throws IOException {
        cosInteger.writePDF(output);
        output.write(COSWriter.SPACE);
    }

    private void writeCOSBoolean(OutputStream output, COSBoolean cosBoolean) throws IOException {
        cosBoolean.writePDF(output);
        output.write(COSWriter.SPACE);
    }

    private void writeCOSName(OutputStream output, COSName cosName) throws IOException {
        cosName.writePDF(output);
        output.write(COSWriter.SPACE);
    }

    private void writeCOSArray(OutputStream output, COSArray cosArray) throws IOException {
        output.write(COSWriter.ARRAY_OPEN);
        for (COSBase cOSBase : cosArray.toList()) {
            if (cOSBase == null) {
                this.writeCOSNull(output);
                continue;
            }
            this.writeObject(output, cOSBase, false);
        }
        output.write(COSWriter.ARRAY_CLOSE);
        output.write(COSWriter.SPACE);
    }

    private void writeCOSDictionary(OutputStream output, COSDictionary cosDictionary) throws IOException {
        output.write(COSWriter.DICT_OPEN);
        for (Map.Entry<COSName, COSBase> entry : cosDictionary.entrySet()) {
            if (entry.getValue() == null) continue;
            this.writeObject(output, entry.getKey(), false);
            this.writeObject(output, entry.getValue(), false);
        }
        output.write(COSWriter.DICT_CLOSE);
        output.write(COSWriter.SPACE);
    }

    private void writeObjectReference(OutputStream output, COSObjectKey indirectReference) throws IOException {
        output.write(String.valueOf(indirectReference.getNumber()).getBytes(StandardCharsets.ISO_8859_1));
        output.write(COSWriter.SPACE);
        output.write(String.valueOf(indirectReference.getGeneration()).getBytes(StandardCharsets.ISO_8859_1));
        output.write(COSWriter.SPACE);
        output.write(COSWriter.REFERENCE);
        output.write(COSWriter.SPACE);
    }

    private void writeCOSNull(OutputStream output) throws IOException {
        output.write("null".getBytes(StandardCharsets.ISO_8859_1));
        output.write(COSWriter.SPACE);
    }
}

